/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.base;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Container;
import org.apache.felix.gogo.commands.basic.SimpleCommand;
import org.fusesource.insight.camel.audit.Auditor;
import org.fusesource.insight.camel.audit.StorageProxy;
import org.fusesource.insight.camel.base.ContainerStrategy;
import org.fusesource.insight.camel.breadcrumb.Breadcrumbs;
import org.fusesource.insight.camel.commands.AuditorCommand;
import org.fusesource.insight.camel.commands.BreadcrumbsCommand;
import org.fusesource.insight.camel.commands.ProfilerCommand;
import org.fusesource.insight.camel.commands.TracerCommand;
import org.fusesource.insight.camel.profiler.Profiler;
import org.fusesource.insight.camel.trace.Tracer;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
Container,
ManagedService {
    public static final String INSIGHT_CAMEL_PID = "org.fusesource.insight.camel";
    public static final String BREADCRUMBS = "breadcrumbs";
    public static final String PROFILER = "profiler";
    public static final String TRACER = "tracer";
    public static final String AUDITOR = "auditor";
    private static final transient Logger LOG = LoggerFactory.getLogger(Activator.class);
    private final Map<String, ContainerStrategy> strategies = new HashMap<String, ContainerStrategy>();
    private StorageProxy storageProxy = new StorageProxy();
    private BundleContext bundleContext;
    private MBeanServer mbeanServer;
    private ServiceRegistration<ManagedService> registration;
    private List<ServiceRegistration> commandRegistrations;

    public Activator() {
        this.strategies.put(BREADCRUMBS, new Breadcrumbs());
        this.strategies.put(PROFILER, new Profiler());
        this.strategies.put(TRACER, new Tracer());
        this.strategies.put(AUDITOR, new Auditor(this.storageProxy));
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.storageProxy.setContext(context);
        this.storageProxy.init();
        this.mbeanServer = this.lookupMBeanServer();
        if (this.mbeanServer != null) {
            for (ContainerStrategy strategy : this.strategies.values()) {
                try {
                    this.mbeanServer.registerMBean(strategy, this.getObjectName(strategy));
                }
                catch (Exception e) {
                    LOG.warn("An error occured during mbean server unregistration: " + e, (Throwable)e);
                }
            }
        }
        Container.Instance.set((Container)this);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", INSIGHT_CAMEL_PID);
        this.registration = this.bundleContext.registerService(ManagedService.class, (Object)this, props);
        this.commandRegistrations = Arrays.asList(SimpleCommand.export((BundleContext)this.bundleContext, AuditorCommand.class), SimpleCommand.export((BundleContext)this.bundleContext, BreadcrumbsCommand.class), SimpleCommand.export((BundleContext)this.bundleContext, ProfilerCommand.class), SimpleCommand.export((BundleContext)this.bundleContext, TracerCommand.class));
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration sr : this.commandRegistrations) {
            sr.unregister();
        }
        this.registration.unregister();
        Container.Instance.set(null);
        if (this.mbeanServer != null) {
            for (ContainerStrategy strategy : this.strategies.values()) {
                try {
                    this.mbeanServer.unregisterMBean(this.getObjectName(strategy));
                }
                catch (Exception e) {
                    LOG.warn("An error occured during mbean server unregistration: " + e, (Throwable)e);
                }
            }
        }
        this.storageProxy.destroy();
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        HashMap props = new HashMap();
        for (String strategy : this.strategies.keySet()) {
            props.put(strategy, new HashMap());
        }
        if (properties != null) {
            Enumeration<String> es = properties.keys();
            while (es.hasMoreElements()) {
                String key = es.nextElement();
                Object val = properties.get(key);
                for (String strategy : this.strategies.keySet()) {
                    if (!key.startsWith(strategy + ".")) continue;
                    key = key.substring((strategy + ".").length());
                    ((Map)props.get(strategy)).put(key, val != null ? val.toString() : null);
                }
            }
        }
        for (String key : this.strategies.keySet()) {
            Map p = (Map)props.get(key);
            this.strategies.get(key).update(p);
        }
    }

    public void manage(CamelContext camelContext) {
        for (ContainerStrategy strategy : this.strategies.values()) {
            try {
                strategy.manage(camelContext);
            }
            catch (Exception e) {
                LOG.error("Error managing CamelContext " + camelContext, (Throwable)e);
            }
        }
    }

    protected ObjectName getObjectName(ContainerStrategy strategy) throws MalformedObjectNameException {
        return new ObjectName("org.fusesource.insight:type=Camel" + strategy.getClass().getSimpleName());
    }

    protected MBeanServer lookupMBeanServer() {
        ServiceReference ref = this.bundleContext.getServiceReference(MBeanServer.class.getName());
        if (ref != null) {
            return (MBeanServer)this.bundleContext.getService(ref);
        }
        LOG.warn("Could not find MBeanServer in the OSGi registry so using the platform MBeanServer instead");
        return ManagementFactory.getPlatformMBeanServer();
    }
}

