/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.breadcrumb;

import java.util.Set;
import org.apache.camel.AsyncCallback;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.fusesource.insight.camel.base.SwitchableContainerStrategy;
import org.fusesource.insight.camel.breadcrumb.BreadcrumbAggregationStrategy;
import org.fusesource.insight.camel.breadcrumb.Breadcrumbs;

public class BreadcrumbsProcessor
extends DelegateAsyncProcessor {
    private final SwitchableContainerStrategy breadcrumbs;

    public BreadcrumbsProcessor(Breadcrumbs breadcrumbs, Processor processor) {
        super(processor);
        this.breadcrumbs = breadcrumbs;
        Processor proc = processor;
        while (proc != null) {
            if (proc instanceof AggregateProcessor) {
                AggregateProcessor ap = (AggregateProcessor)proc;
                ap.setAggregationStrategy(this.wrap(ap.getAggregationStrategy()));
            }
            if (proc instanceof DelegateProcessor) {
                proc = ((DelegateProcessor)proc).getProcessor();
                continue;
            }
            proc = null;
        }
    }

    protected AggregationStrategy wrap(AggregationStrategy strategy) {
        return new BreadcrumbAggregationStrategy(strategy);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.breadcrumbs.isEnabled(exchange)) {
            Set<String> breadcrumbs = Breadcrumbs.getBreadcrumbs(exchange);
            breadcrumbs.add(exchange.getExchangeId());
        }
        return this.processor.process(exchange, callback);
    }

    public String toString() {
        return "Breadcrumbs[" + this.processor + "]";
    }
}

