/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.profiler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.fusesource.insight.camel.profiler.Stats;

public class ExchangeData
implements Synchronization {
    final Map<Stats, ProcessorData> data = new HashMap<Stats, ProcessorData>();
    final LinkedList<Stats> queue = new LinkedList();
    long last;
    long level;
    boolean completed;

    public void onComplete(Exchange exchange) {
        this.completed = true;
        this.checkCompletedExchange();
    }

    public void onFailure(Exchange exchange) {
        this.onComplete(exchange);
    }

    public void start(Stats stats) {
        long cur = System.nanoTime();
        Stats prev = this.queue.peek();
        if (prev != null) {
            this.addTime(prev, cur - this.last);
        }
        this.queue.addFirst(stats);
        this.last = cur;
        ++this.level;
    }

    public boolean stop(Stats stats) {
        long cur = System.nanoTime();
        Stats ppd = this.queue.poll();
        assert (stats == ppd);
        this.addTime(stats, cur - this.last);
        this.last = cur;
        --this.level;
        return this.checkCompletedExchange();
    }

    ProcessorData getData(Stats stats) {
        ProcessorData pd = this.data.get(stats);
        if (pd == null) {
            pd = new ProcessorData();
            this.data.put(stats, pd);
        }
        return pd;
    }

    void addTime(Stats stats, long time) {
        this.getData((Stats)stats).time += time;
        Stats s = stats;
        while (s != null) {
            this.getData((Stats)s).total += time;
            s = s.parent;
        }
    }

    boolean checkCompletedExchange() {
        if (this.completed && this.level == 0L) {
            for (Map.Entry<Stats, ProcessorData> e : this.data.entrySet()) {
                e.getKey().addTime(e.getValue().time, e.getValue().total);
            }
            return true;
        }
        return false;
    }

    public static class ProcessorData {
        long time;
        long total;
    }
}

