/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.base;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.management.DefaultManagementNamingStrategy;
import org.apache.camel.util.ObjectHelper;

public class InsightManagementNamingStrategy
extends DefaultManagementNamingStrategy {
    public static final String TYPE_FABRIC = "fabric";
    public static final String TYPE_INSIGHT = "insight";

    public InsightManagementNamingStrategy(String domainName) {
        super(domainName);
    }

    public ObjectName getObjectNameForService(CamelContext context, Service service) throws MalformedObjectNameException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        if (service.getClass().getCanonicalName().startsWith("org.apache.camel.fabric")) {
            buffer.append("type=fabric,");
        } else if (service.getClass().getCanonicalName().startsWith("org.fusesource.insight.camel")) {
            buffer.append("type=insight,");
        } else {
            buffer.append("type=services,");
        }
        buffer.append("name=").append(service.getClass().getSimpleName()).append("(").append(ObjectHelper.getIdentityHashCode((Object)service)).append(")");
        return this.createObjectName(buffer);
    }
}

