/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.trace;

import java.util.Date;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.MessageHelper;
import org.fusesource.insight.camel.trace.Tracer;
import org.fusesource.insight.camel.trace.TracerEventMessage;

public class TraceProcessor
extends DelegateAsyncProcessor {
    private final Queue<TracerEventMessage> queue;
    private final Tracer tracer;
    private final ProcessorDefinition<?> processorDefinition;
    private final ProcessorDefinition<?> routeDefinition;
    private final boolean first;

    public TraceProcessor(Queue<TracerEventMessage> queue, Processor processor, ProcessorDefinition<?> processorDefinition, ProcessorDefinition<?> routeDefinition, boolean first, Tracer tracer) {
        super(processor);
        this.queue = queue;
        this.processorDefinition = processorDefinition;
        this.routeDefinition = routeDefinition;
        this.first = first;
        this.tracer = tracer;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.tracer.isEnabled(exchange)) {
            try {
                int drain = this.queue.size() - this.tracer.getQueueSize();
                if (drain > 0) {
                    for (int i = 0; i < drain; ++i) {
                        this.queue.poll();
                    }
                }
                Date timestamp = new Date();
                String toNode = this.processorDefinition.getId();
                String exchangeId = exchange.getExchangeId();
                String messageAsXml = MessageHelper.dumpAsXml((Message)exchange.getIn());
                if (this.first) {
                    Date created = (Date)exchange.getProperty("CamelCreatedTimestamp", (Object)timestamp, Date.class);
                    String routeId = this.routeDefinition.getId();
                    TracerEventMessage pseudo = new TracerEventMessage(this.tracer.incrementTraceCounter(), created, routeId, exchangeId, messageAsXml);
                    this.queue.add(pseudo);
                }
                TracerEventMessage event = new TracerEventMessage(this.tracer.incrementTraceCounter(), timestamp, toNode, exchangeId, messageAsXml);
                this.queue.add(event);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        return this.processor.process(exchange, callback);
    }

    public void stop() throws Exception {
        super.stop();
        this.queue.clear();
        this.tracer.stopProcessor(this, this.processorDefinition);
    }

    public String toString() {
        return "Tracer[" + this.processor + "]";
    }
}

