/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.audit;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.spi.EventNotifier;
import org.fusesource.insight.camel.audit.AuditorMBean;
import org.fusesource.insight.camel.audit.IoUtils;
import org.fusesource.insight.camel.audit.ScriptUtils;
import org.fusesource.insight.camel.base.SwitchableContainerStrategy;
import org.fusesource.insight.storage.StorageService;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Auditor")
public class Auditor
extends SwitchableContainerStrategy
implements EventNotifier,
ManagedService,
AuditorMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(Auditor.class);
    private StorageService storage;
    private String type = "camel";
    private boolean ignoreExchangeCreatedEvent;
    private boolean ignoreExchangeCompletedEvent;
    private boolean ignoreExchangeFailedEvents;
    private boolean ignoreExchangeRedeliveryEvents;
    private boolean ignoreExchangeSendingEvents;
    private boolean ignoreExchangeSentEvents;
    private Dictionary<String, ?> properties;
    private ParserContext context;
    private Map<String, CompiledTemplate> templates = new ConcurrentHashMap<String, CompiledTemplate>();
    private Map<URL, String> sources = new ConcurrentHashMap<URL, String>();
    private URL defaultTemplateUrl = this.getClass().getResource("default.mvel");

    public Auditor() {
        this(null);
    }

    public Auditor(StorageService storage) {
        super(false);
        this.storage = storage;
        this.context = new ParserContext();
        try {
            this.context.addImport("toJson", ScriptUtils.class.getMethod("toJson", Object.class));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find method toJson", e);
        }
    }

    @Override
    public void manage(CamelContext context) throws Exception {
        context.getManagementStrategy().addEventNotifier((EventNotifier)this);
    }

    public StorageService getStorage() {
        return this.storage;
    }

    public void setStorage(StorageService storage) {
        this.storage = storage;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.properties = properties;
    }

    public void notify(EventObject eventObject) throws Exception {
        AbstractExchangeEvent aee;
        if (eventObject instanceof AbstractExchangeEvent && this.isEnabled((aee = (AbstractExchangeEvent)eventObject).getExchange())) {
            if (aee instanceof ExchangeSendingEvent) {
                aee.getExchange().getIn().setHeader("AuditCallId", (Object)aee.getExchange().getContext().getUuidGenerator().generateUuid());
            }
            String json = this.toJson(aee);
            this.storage.store(this.type, System.currentTimeMillis(), json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toJson(AbstractExchangeEvent event) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Auditor.class.getClassLoader());
            String eventType = event.getClass().getSimpleName();
            eventType = eventType.substring("Exchange".length());
            eventType = eventType.substring(0, eventType.length() - "Event".length());
            CompiledTemplate template = this.getTemplate(eventType, event.getExchange());
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("event", eventType);
            vars.put("host", System.getProperty("karaf.name"));
            vars.put("timestamp", new Date());
            vars.put("exchange", event.getExchange());
            String string = TemplateRuntime.execute((CompiledTemplate)template, (Object)this.context, vars).toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private CompiledTemplate getTemplate(String event, Exchange exchange) {
        String source = this.getTemplateSource(event, exchange);
        CompiledTemplate template = this.templates.get(source);
        if (template == null) {
            template = TemplateCompiler.compileTemplate((String)source, (ParserContext)this.context);
            this.templates.put(source, template);
        }
        return template;
    }

    private String getTemplateSource(String event, Exchange exchange) {
        String source = null;
        URL url = this.getTemplateUrl(event, exchange);
        if (url != null) {
            try {
                source = this.loadSource(url);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to load mvel template " + url, (Throwable)e);
            }
        }
        if (source == null) {
            try {
                source = this.loadSource(this.defaultTemplateUrl);
            }
            catch (IOException e) {
                throw new IllegalStateException("Default template could not be loaded", e);
            }
        }
        return source;
    }

    private URL getTemplateUrl(String event, Exchange exchange) {
        return null;
    }

    private String loadSource(URL url) throws IOException {
        String source = this.sources.get(url);
        if (source == null) {
            source = IoUtils.loadFully(url);
            this.sources.put(url, source);
        }
        return source;
    }

    public boolean isEnabled(EventObject eventObject) {
        return true;
    }

    public boolean isIgnoreCamelContextEvents() {
        return true;
    }

    public void setIgnoreCamelContextEvents(boolean ignoreCamelContextEvents) {
    }

    public boolean isIgnoreRouteEvents() {
        return true;
    }

    public void setIgnoreRouteEvents(boolean ignoreRouteEvents) {
    }

    public boolean isIgnoreServiceEvents() {
        return true;
    }

    public void setIgnoreServiceEvents(boolean ignoreServiceEvents) {
    }

    public boolean isIgnoreExchangeEvents() {
        return false;
    }

    public void setIgnoreExchangeEvents(boolean ignoreExchangeEvents) {
    }

    public boolean isIgnoreExchangeCreatedEvent() {
        return this.ignoreExchangeCreatedEvent;
    }

    public void setIgnoreExchangeCreatedEvent(boolean ignoreExchangeCreatedEvent) {
        this.ignoreExchangeCreatedEvent = ignoreExchangeCreatedEvent;
    }

    public boolean isIgnoreExchangeCompletedEvent() {
        return this.ignoreExchangeCompletedEvent;
    }

    public void setIgnoreExchangeCompletedEvent(boolean ignoreExchangeCompletedEvent) {
        this.ignoreExchangeCompletedEvent = ignoreExchangeCompletedEvent;
    }

    public boolean isIgnoreExchangeFailedEvents() {
        return this.ignoreExchangeFailedEvents;
    }

    public void setIgnoreExchangeFailedEvents(boolean ignoreExchangeFailedEvents) {
        this.ignoreExchangeFailedEvents = ignoreExchangeFailedEvents;
    }

    public boolean isIgnoreExchangeRedeliveryEvents() {
        return this.ignoreExchangeRedeliveryEvents;
    }

    public void setIgnoreExchangeRedeliveryEvents(boolean ignoreExchangeRedeliveryEvents) {
        this.ignoreExchangeRedeliveryEvents = ignoreExchangeRedeliveryEvents;
    }

    public boolean isIgnoreExchangeSendingEvents() {
        return this.ignoreExchangeSendingEvents;
    }

    public void setIgnoreExchangeSendingEvents(boolean ignoreExchangeSendingEvents) {
        this.ignoreExchangeSendingEvents = ignoreExchangeSendingEvents;
    }

    public boolean isIgnoreExchangeSentEvents() {
        return this.ignoreExchangeSentEvents;
    }

    public void setIgnoreExchangeSentEvents(boolean ignoreExchangeSentEvents) {
        this.ignoreExchangeSentEvents = ignoreExchangeSentEvents;
    }
}

