/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.camel.commands;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class BaseCommand
extends OsgiCommandSupport {
    @Argument(name="enabled", required=false)
    Boolean enabled;
    @Option(name="--context")
    String context;
    @Option(name="--route")
    String route;
    @Option(name="--reset")
    boolean reset;
    @Option(name="--clear")
    boolean clear;

    public abstract String getStrategy();

    public Object execute(CommandSession session) throws Exception {
        this.setBundleContext(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext());
        return super.execute(session);
    }

    protected Object doExecute() throws Exception {
        Configuration cfg = this.getConfiguration();
        Hashtable<String, String> props = cfg.getProperties();
        if (props == null) {
            props = new Hashtable<String, String>();
        }
        if (!this.reset && !this.clear && this.enabled == null && this.context == null && this.route == null) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            Enumeration e = ((Dictionary)props).keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!s.startsWith(this.getStrategy())) continue;
                map.put(s.substring(this.getStrategy().length() + 1), ((Dictionary)props).get(s).toString());
            }
            if (map.isEmpty()) {
                System.out.println("No configuration set");
            }
            for (Map.Entry e2 : map.entrySet()) {
                System.out.println((String)e2.getKey() + " = " + (String)e2.getValue());
            }
            return null;
        }
        if (this.reset) {
            HashSet<String> keys = new HashSet<String>();
            Enumeration e = ((Dictionary)props).keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!s.startsWith(this.getStrategy())) continue;
                keys.add(s);
            }
            for (String s : keys) {
                ((Dictionary)props).remove(s);
            }
        }
        String key = this.context != null ? this.getStrategy() + ".context." + this.context : (this.route != null ? this.getStrategy() + ".route." + this.route : this.getStrategy() + ".enabled");
        if (this.clear) {
            ((Dictionary)props).remove(key);
        } else if (this.enabled != null) {
            ((Dictionary)props).put(key, this.enabled.toString());
        }
        cfg.update(props);
        return null;
    }

    protected Configuration getConfiguration() throws IOException {
        return this.getConfigAdmin().getConfiguration("org.fusesource.insight.camel", null);
    }

    protected ConfigurationAdmin getConfigAdmin() {
        ServiceReference ref = this.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        return (ConfigurationAdmin)this.getService(ref);
    }
}

