/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.itests;

import io.fabric8.itests.paxexam.support.FabricTestSupport;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.fusesource.insight.log.LogEvent;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.LogResults;
import org.fusesource.insight.log.service.LogQueryMBean;
import org.fusesource.insight.log.support.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.JUnit4TestRunner;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4TestRunner.class)
@ExamReactorStrategy(value={AllConfinedStagedReactorFactory.class})
public class PaxLoggingTest
extends FabricTestSupport {
    String info1 = "InfoOne message";
    String info2 = "InfoTwo message";
    String debug1 = "DebugOne message";
    String debug2 = "DebugOne message";
    String warn1 = "WarnOne message";
    String warn2 = "WarnTwo message";
    String error1 = "ErrorOne message";
    String error2 = "ErrorTwo message";

    @Test
    public void testQueryOfLogMessages() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        LogQueryMBean logQuery = JMX.newMBeanProxy(mbs, new ObjectName("org.fusesource.insight:type=LogQuery"), LogQueryMBean.class);
        Logger LOG = LoggerFactory.getLogger(PaxLoggingTest.class);
        LOG.info(this.info1);
        LOG.debug(this.debug1);
        LOG.warn(this.warn1);
        LOG.error(this.error1);
        LOG.info(this.info2);
        LOG.debug(this.debug2);
        LOG.warn(this.warn2);
        LOG.error(this.error2);
        this.assertLogQuery(logQuery);
    }

    protected void assertLogQuery(LogQueryMBean mBean) throws Exception {
        LogResults results = mBean.allLogResults();
        List<LogEvent> logEvents = PaxLoggingTest.assertNotEmpty(results);
        PaxLoggingTest.assertMatches(logEvents, PaxLoggingTest.messagePredicate("INFO", this.info1));
        PaxLoggingTest.assertMatches(logEvents, PaxLoggingTest.messagePredicate("INFO", this.info2));
        PaxLoggingTest.assertMatches(logEvents, PaxLoggingTest.messagePredicate("ERROR", this.error1));
        PaxLoggingTest.assertMatches(logEvents, PaxLoggingTest.messagePredicate("ERROR", this.error2));
        LogFilter filter = new LogFilter();
        filter.setLevels(new String[]{"ERROR"});
        logEvents = PaxLoggingTest.assertNotEmpty(mBean.queryLogResults(filter));
        PaxLoggingTest.assertMatches(logEvents, PaxLoggingTest.messagePredicate("ERROR", this.error1));
        PaxLoggingTest.assertMatches(logEvents, PaxLoggingTest.messagePredicate("ERROR", this.error2));
        PaxLoggingTest.assertNotMatches(logEvents, PaxLoggingTest.messagePredicate("INFO", this.info1));
        PaxLoggingTest.assertNotMatches(logEvents, PaxLoggingTest.messagePredicate("INFO", this.info2));
    }

    public static Predicate<LogEvent> messagePredicate(final String level, final String message) {
        return new Predicate<LogEvent>(){

            public boolean matches(LogEvent logEvent) {
                return level.equals(logEvent.getLevel()) && message.equals(logEvent.getMessage());
            }

            public String toString() {
                return "MessagePredicate(level: '" + level + "' message: " + message + "')";
            }
        };
    }

    public static List<LogEvent> assertNotEmpty(LogResults results) {
        Assert.assertNotNull((String)"Should have a LogResults", (Object)results);
        List events = results.getEvents();
        Assert.assertNotNull((String)"Should have events", (Object)events);
        Assert.assertTrue((String)"Events.size() should not be zero!", (events.size() > 0 ? 1 : 0) != 0);
        Long fromTimestamp = results.getFromTimestamp();
        Long toTimestamp = results.getToTimestamp();
        Assert.assertNotNull((String)"Should have a fromTimestamp", (Object)fromTimestamp);
        Assert.assertNotNull((String)"Should have a toTimestamp", (Object)toTimestamp);
        return events;
    }

    public static <T> void assertMatches(List<T> logEvents, Predicate<T> predicate) {
        StringBuffer buffer = new StringBuffer();
        for (T element : logEvents) {
            if (predicate.matches(element)) {
                return;
            }
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(element);
        }
        Assert.fail((String)("Could not find message matching " + predicate + " when found: " + buffer));
    }

    public static <T> void assertNotMatches(List<T> logEvents, Predicate<T> predicate) {
        for (T element : logEvents) {
            if (!predicate.matches(element)) continue;
            Assert.fail((String)("Found element " + element + " which should not match predicatE: " + predicate));
        }
    }

    @Configuration
    public Option[] config() {
        return new Option[]{new DefaultCompositeOption(this.fabricDistributionConfiguration())};
    }
}

