/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.storage;

import org.fusesource.insight.log.storage.InsightLogAppender;
import org.fusesource.insight.log.storage.InsightUtils;
import org.fusesource.insight.storage.StorageService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightEventHandler
implements EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsightLogAppender.class);
    private String name;
    private String index;
    private String type;
    private StorageService storage;

    public void setName(String name) {
        this.name = name;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStorage(StorageService storage) {
        this.storage = storage;
    }

    public void handleEvent(Event event) {
        try {
            StringBuilder writer = new StringBuilder();
            writer.append("{ \"host\": ");
            InsightUtils.quote(this.name, writer);
            writer.append(", \"topic\": ");
            InsightUtils.quote(event.getTopic(), writer);
            writer.append(", \"properties\": { ");
            boolean first = true;
            long timestamp = 0L;
            for (String name : event.getPropertyNames()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(", ");
                }
                InsightUtils.quote(name, writer);
                writer.append(": ");
                Object value = event.getProperty(name);
                if (value == null) {
                    writer.append("null");
                    continue;
                }
                if ("timestamp".equals(name) && value instanceof Long) {
                    timestamp = (Long)value;
                    InsightUtils.quote(InsightUtils.formatDate(timestamp), writer);
                    continue;
                }
                if (value.getClass().isArray()) {
                    writer.append(" [ ");
                    boolean vfirst = true;
                    for (Object v : (Object[])value) {
                        if (!vfirst) {
                            writer.append(", ");
                        } else {
                            vfirst = false;
                        }
                        InsightUtils.quote(v.toString(), writer);
                    }
                    writer.append(" ] ");
                    continue;
                }
                InsightUtils.quote(value.toString(), writer);
            }
            writer.append(" } }");
            if (timestamp == 0L) {
                timestamp = System.currentTimeMillis();
            }
            this.storage.store(this.type, timestamp, writer.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Error appending log to elastic search", (Throwable)e);
        }
    }
}

