/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.maven.aether;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferResource;
import scala.Function1;
import scala.MatchError;
import scala.Math$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u00015\u0011qcQ8og>dW\r\u0016:b]N4WM\u001d'jgR,g.\u001a:\u000b\u0005\r!\u0011AB1fi\",'O\u0003\u0002\u0006\r\u0005)Q.\u0019<f]*\u0011q\u0001C\u0001\bS:\u001c\u0018n\u001a5u\u0015\tI!\"\u0001\u0006gkN,7o\\;sG\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u000199\u0002CA\b\u0016\u001b\u0005\u0001\"BA\t\u0013\u0003!!(/\u00198tM\u0016\u0014(BA\u0002\u0014\u0015\t!\"\"\u0001\u0005t_:\fG/\u001f9f\u0013\t1\u0002C\u0001\rBEN$(/Y2u)J\fgn\u001d4fe2K7\u000f^3oKJ\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u00111bU2bY\u0006|%M[3di\"Aa\u0004\u0001B\u0001B\u0003%q$A\u0002pkR\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0005%|'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u00121\u0002\u0015:j]R\u001cFO]3b[\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000by9\u0003\u0019A\u0010\t\u000f9\u0002\u0001\u0019!C\u0001_\u0005QA.Y:u\u0019\u0016tw\r\u001e5\u0016\u0003A\u0002\"\u0001G\u0019\n\u0005IJ\"aA%oi\"9A\u0007\u0001a\u0001\n\u0003)\u0014A\u00047bgRdUM\\4uQ~#S-\u001d\u000b\u0003me\u0002\"\u0001G\u001c\n\u0005aJ\"\u0001B+oSRDqAO\u001a\u0002\u0002\u0003\u0007\u0001'A\u0002yIEBa\u0001\u0010\u0001!B\u0013\u0001\u0014a\u00037bgRdUM\\4uQ\u0002BqA\u0010\u0001A\u0002\u0013\u0005q(A\u0005e_^tGn\\1egV\t\u0001\t\u0005\u0003B\r\"[U\"\u0001\"\u000b\u0005\r#\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u000bf\t!bY8mY\u0016\u001cG/[8o\u0013\t9%IA\u0004ICNDW*\u00199\u0011\u0005=I\u0015B\u0001&\u0011\u0005A!&/\u00198tM\u0016\u0014(+Z:pkJ\u001cW\r\u0005\u0002\u0019\u0019&\u0011Q*\u0007\u0002\u0005\u0019>tw\rC\u0004P\u0001\u0001\u0007I\u0011\u0001)\u0002\u001b\u0011|wO\u001c7pC\u0012\u001cx\fJ3r)\t1\u0014\u000bC\u0004;\u001d\u0006\u0005\t\u0019\u0001!\t\rM\u0003\u0001\u0015)\u0003A\u0003)!wn\u001e8m_\u0006$7\u000f\t\u0005\u0006+\u0002!\tEV\u0001\u0012iJ\fgn\u001d4feN+8mY3fI\u0016$GC\u0001\u001cX\u0011\u0015AF\u000b1\u0001Z\u0003\u0015)g/\u001a8u!\ty!,\u0003\u0002\\!\tiAK]1og\u001a,'/\u0012<f]RDQ!\u0018\u0001\u0005By\u000b!\u0003\u001e:b]N4WM\u001d)s_\u001e\u0014Xm]:fIR\u0011ag\u0018\u0005\u00061r\u0003\r!\u0017\u0005\u0006C\u0002!\tEY\u0001\u0012iJ\fgn\u001d4fe&s\u0017\u000e^5bi\u0016$GC\u0001\u001cd\u0011\u0015A\u0006\r1\u0001Z\u0011\u0015)\u0007\u0001\"\u0011g\u00039!(/\u00198tM\u0016\u0014h)Y5mK\u0012$\"AN4\t\u000ba#\u0007\u0019A-\t\u000b%\u0004A\u0011\t6\u0002#Q\u0014\u0018M\\:gKJ\u001cuN\u001d:vaR,G\r\u0006\u00027W\")\u0001\f\u001ba\u00013\")Q\u000e\u0001C\t]\u0006Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0004_V<\bC\u00019t\u001b\u0005\t(B\u0001:$\u0003\u0011a\u0017M\\4\n\u0005Q\f(AB*ue&tw\rC\u0003wY\u0002\u00071*\u0001\u0005d_6\u0004H.\u001a;f\u0011\u0015AH\u000e1\u0001L\u0003\u0015!x\u000e^1m\u0011\u0015Q\b\u0001\"\u0005|\u0003\r\u0001\u0018\r\u001a\u000b\u0005mq\f)\u0002C\u0003~s\u0002\u0007a0\u0001\u0004ck\u001a4WM\u001d\t\u0004\u007f\u0006=a\u0002BA\u0001\u0003\u0017qA!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000fa\u0011A\u0002\u001fs_>$h(C\u0001\u001b\u0013\r\ti!G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t\"a\u0005\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0015\r\ti!\u0007\u0005\u0007\u0003/I\b\u0019\u0001\u0019\u0002\tML'0\u001a\u0005\b\u00037\u0001A\u0011CA\u000f\u0003\u0011!xn\u0013\"\u0015\u0007-\u000by\u0002C\u0004\u0002\"\u0005e\u0001\u0019A&\u0002\u000b\tLH/Z:\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(\u0005\tBO]1og\u001a,'oQ8na2,G/\u001a3\u0015\u0007Y\nI\u0003\u0003\u0004Y\u0003G\u0001\r!\u0017")
public class ConsoleTransferListener
extends AbstractTransferListener
implements ScalaObject {
    private final PrintStream out;
    private int lastLength;
    private HashMap<TransferResource, Object> downloads;

    public int lastLength() {
        return this.lastLength;
    }

    public void lastLength_$eq(int n) {
        this.lastLength = n;
    }

    public HashMap<TransferResource, Object> downloads() {
        return this.downloads;
    }

    public void downloads_$eq(HashMap<TransferResource, Object> hashMap) {
        this.downloads = hashMap;
    }

    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            TransferEvent.RequestType requestType = event.getRequestType();
            TransferEvent.RequestType requestType2 = TransferEvent.RequestType.PUT;
            String message = !(requestType != null ? !requestType.equals(requestType2) : requestType2 != null) ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? new StringBuilder().append(this.toKB(contentLength)).append((Object)" KB").toString() : new StringBuilder().append(contentLength).append((Object)" B").toString();
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = new StringBuilder().append((Object)" at ").append((Object)format.format(kbPerSec)).append((Object)" KB/sec").toString();
            }
            this.out.println(new StringBuilder().append((Object)message).append((Object)": ").append((Object)resource.getRepositoryUrl()).append((Object)resource.getResourceName()).append((Object)" (").append((Object)len).append((Object)throughput).append((Object)")").toString());
        }
    }

    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)resource).$minus$greater((Object)BoxesRunTime.boxToLong((long)event.getTransferredBytes())));
        StringBuilder buffer$1 = new StringBuilder(64);
        ((HashMap)this.downloads().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TransferResource, Object> tuple2) {
                Tuple2<TransferResource, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this, buffer$1){
            public static final long serialVersionUID;
            private final ConsoleTransferListener $outer;
            private final StringBuilder buffer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(Tuple2<TransferResource, Object> tuple2) {
                Tuple2<TransferResource, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    TransferResource transferResource = (TransferResource)tuple22._1();
                    long l = BoxesRunTime.unboxToLong((Object)tuple22._2());
                    TransferResource key = transferResource;
                    long value = l;
                    long total = key.getContentLength();
                    long complete = Predef$.MODULE$.long2Long(value);
                    return this.buffer$1.append(this.$outer.getStatus(complete, total)).append("  ");
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$1 = stringBuilder;
            }
        });
        int size = this.lastLength() - buffer$1.length();
        this.lastLength_$eq(buffer$1.length());
        this.pad(buffer$1, size);
        buffer$1.append('\r');
        this.out.print(buffer$1);
    }

    public void transferInitiated(TransferEvent event) {
        TransferEvent.RequestType requestType = event.getRequestType();
        TransferEvent.RequestType requestType2 = TransferEvent.RequestType.PUT;
        String message = !(requestType != null ? !requestType.equals(requestType2) : requestType2 != null) ? "Uploading" : "Downloading";
        this.out.println(new StringBuilder().append((Object)message).append((Object)": ").append((Object)event.getResource().getRepositoryUrl()).append((Object)event.getResource().getResourceName()).toString());
    }

    public void transferFailed(TransferEvent event) {
        this.transferCompleted(event);
        event.getException().printStackTrace(this.out);
    }

    public void transferCorrupted(TransferEvent event) {
        event.getException().printStackTrace(this.out);
    }

    public String getStatus(long complete, long total) {
        return total >= 1024L ? new StringBuilder().append(this.toKB(complete)).append((Object)"/").append((Object)BoxesRunTime.boxToLong((long)this.toKB(total))).append((Object)" KB ").toString() : (total >= 0L ? new StringBuilder().append(complete).append((Object)"/").append((Object)BoxesRunTime.boxToLong((long)total)).append((Object)" B ").toString() : (complete >= 1024L ? new StringBuilder().append(this.toKB(complete)).append((Object)" KB ").toString() : new StringBuilder().append(complete).append((Object)" B ").toString()));
    }

    public void pad(StringBuilder buffer, int size) {
        int n;
        String block = "                                        ";
        for (int spaces = size; spaces > 0; spaces -= n) {
            n = Math$.MODULE$.min(spaces, block.length());
            buffer.append(block.substring(0, n));
        }
    }

    public long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }

    private void transferCompleted(TransferEvent event) {
        this.downloads().remove((Object)event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength());
        buffer.append('\r');
        this.out.print(buffer);
    }

    public ConsoleTransferListener(PrintStream out) {
        this.out = out;
        this.lastLength = 0;
        this.downloads = new HashMap();
    }
}

