/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.metrics.support;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public final class ScriptUtils {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toIso(Date d) {
        return format.format(d);
    }

    public static String toJson(Object o) {
        try {
            return mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize " + o, e);
        }
    }

    public static Map parseJson(String str) {
        try {
            return (Map)mapper.readValue(str, Map.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not deserialize " + str, e);
        }
    }

    static {
        mapper.setSerializationConfig(mapper.getSerializationConfig().withDateFormat((DateFormat)format));
    }
}

