/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateFlightBookingStrategy
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateFlightBookingStrategy.class);

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        String to = (String)newExchange.getProperty("CamelToEndpoint", String.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug("To endpoint = {}", (Object)to);
        }
        if (to.contains("FlightConnectionInfo")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Flight Connection Info to exchange.");
            }
            return this.mergeHeaderIntoOldExchange("flightConnectionInfo", oldExchange, newExchange);
        }
        if (to.contains("FlightCustomerInfo")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Flight Customer Info to exchange.");
            }
            return this.mergeHeaderIntoOldExchange("flightCustomerInfo", oldExchange, newExchange);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding Passenger Info to exchange.");
        }
        return this.mergeHeaderIntoOldExchange("passengerInfo", oldExchange, newExchange);
    }

    public Exchange mergeHeaderIntoOldExchange(String messageHeader, Exchange oldExchange, Exchange newExchange) {
        Exchange answer = oldExchange == null ? newExchange : oldExchange;
        answer.getIn().setHeader(messageHeader, newExchange.getIn().getHeader(messageHeader));
        return answer;
    }
}

