/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import java.util.Date;
import org.apache.camel.Exchange;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFlightConnectionGetDetailRequest {
    private static final Logger LOG = LoggerFactory.getLogger(CreateFlightConnectionGetDetailRequest.class);

    public void create(Exchange exchange) throws Exception {
        Structure flightConnectionGetListResponse = (Structure)exchange.getIn().getBody(Structure.class);
        if (flightConnectionGetListResponse == null) {
            throw new Exception("No Flight Connection Get List Response.");
        }
        Table connectionList = (Table)flightConnectionGetListResponse.get((Object)"FLIGHT_CONNECTION_LIST", Table.class);
        if (connectionList == null || connectionList.size() == 0) {
            throw new Exception("No Flight Connections");
        }
        Structure connection = (Structure)connectionList.get(0);
        SAPEndpoint endpoint = (SAPEndpoint)exchange.getContext().getEndpoint("sap:destination:nplDest:BAPI_FLCONN_GETDETAIL", SAPEndpoint.class);
        Structure request = endpoint.getRequest();
        String connectionNumber = (String)connection.get((Object)"FLIGHTCONN", String.class);
        if (connectionNumber != null) {
            request.put((Object)"CONNECTIONNUMBER", (Object)connectionNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CONNECTIONNUMBER = '{}' to request", (Object)connectionNumber);
            }
        } else {
            throw new Exception("No Flight Connection Number");
        }
        String travelAgencyNumber = (String)connection.get((Object)"AGENCYNUM", String.class);
        if (travelAgencyNumber != null) {
            request.put((Object)"TRAVELAGENCYNUMBER", (Object)travelAgencyNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TRAVELAGENCYNUMBER = '{}' to request", (Object)travelAgencyNumber);
            }
        } else {
            throw new Exception("No Agency Number");
        }
        Date flightDate = (Date)connection.get((Object)"FLIGHTDATE", Date.class);
        if (flightDate != null) {
            request.put((Object)"FLIGHTDATE", (Object)flightDate);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added FLIGHTDATE = '{}' to request", (Object)flightDate);
            }
        } else {
            throw new Exception("No Flight Date");
        }
        request.put((Object)"NO_AVAILIBILITY", (Object)"");
        exchange.getIn().setBody((Object)request);
    }
}

