/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import org.apache.camel.Exchange;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.sap.example.jaxb.BookFlightRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFlightCustomerGetListRequest {
    private static final Logger LOG = LoggerFactory.getLogger(CreateFlightCustomerGetListRequest.class);

    public void create(Exchange exchange) throws Exception {
        BookFlightRequest bookFlightRequest = (BookFlightRequest)exchange.getIn().getBody(BookFlightRequest.class);
        SAPEndpoint endpoint = (SAPEndpoint)exchange.getContext().getEndpoint("sap:destination:nplDest:BAPI_FLCUST_GETLIST", SAPEndpoint.class);
        Structure request = endpoint.getRequest();
        if (bookFlightRequest.getCustomerName() != null && bookFlightRequest.getCustomerName().length() > 0) {
            request.put((Object)"CUSTOMER_NAME", (Object)bookFlightRequest.getCustomerName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CUSTOMER_NAME = '{}' to request", (Object)bookFlightRequest.getCustomerName());
            }
        } else {
            throw new Exception("No Customer Name");
        }
        exchange.getIn().setBody((Object)request);
    }
}

