/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import java.util.Date;
import org.apache.camel.Exchange;
import org.fusesource.camel.component.sap.SAPEndpoint;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.fusesource.sap.example.bean.FlightConnectionInfo;
import org.fusesource.sap.example.bean.FlightCustomerInfo;
import org.fusesource.sap.example.bean.PassengerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFlightTripRequest {
    private static final Logger LOG = LoggerFactory.getLogger(CreateFlightTripRequest.class);

    public void create(Exchange exchange) throws Exception {
        Date passengerDateOfBirth;
        String passengerName;
        String flightConnectionClass;
        Date flightConnectionDepartureData;
        String flightConnectionNumber;
        String flightCustomerNumber;
        FlightConnectionInfo flightConnectionInfo = (FlightConnectionInfo)exchange.getIn().getHeader("flightConnectionInfo", FlightConnectionInfo.class);
        FlightCustomerInfo flightCustomerInfo = (FlightCustomerInfo)exchange.getIn().getHeader("flightCustomerInfo", FlightCustomerInfo.class);
        PassengerInfo passengerInfo = (PassengerInfo)exchange.getIn().getHeader("passengerInfo");
        SAPEndpoint endpoint = (SAPEndpoint)exchange.getContext().getEndpoint("sap:destination:nplDest:BAPI_FLTRIP_CREATE", SAPEndpoint.class);
        Structure request = endpoint.getRequest();
        Structure flightTripData = (Structure)request.get((Object)"FLIGHT_TRIP_DATA", Structure.class);
        String travelAgencyNumber = flightConnectionInfo.getTravelAgencyNumber();
        if (travelAgencyNumber != null && travelAgencyNumber.length() != 0) {
            flightTripData.put((Object)"AGENCYNUM", (Object)travelAgencyNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added AGENCYNUM = '{}' to FLIGHT_TRIP_DATA", (Object)travelAgencyNumber);
            }
        }
        if ((flightCustomerNumber = flightCustomerInfo.getCustomerNumber()) != null && flightCustomerNumber.length() != 0) {
            flightTripData.put((Object)"CUSTOMERID", (Object)flightCustomerNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CUSTOMERID = '{}' to FLIGHT_TRIP_DATA", (Object)flightCustomerNumber);
            }
        }
        if ((flightConnectionNumber = flightConnectionInfo.getFlightConnectionNumber()) != null && flightConnectionNumber.length() != 0) {
            flightTripData.put((Object)"FLCONN1", (Object)flightConnectionNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added FLCONN1 = '{}' to FLIGHT_TRIP_DATA", (Object)flightConnectionNumber);
            }
        }
        if ((flightConnectionDepartureData = flightConnectionInfo.getDepartureDate()) != null) {
            flightTripData.put((Object)"FLDATE1", (Object)flightConnectionDepartureData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added FLDATE1 = '{}' to FLIGHT_TRIP_DATA", (Object)flightConnectionDepartureData);
            }
        }
        if ((flightConnectionClass = "Y") != null && flightConnectionClass.length() != 0) {
            flightTripData.put((Object)"CLASS", (Object)flightConnectionClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CLASS = '{}' to FLIGHT_TRIP_DATA", (Object)flightConnectionClass);
            }
        }
        Table passengerList = (Table)request.get((Object)"PASSENGER_LIST", Table.class);
        Structure passengerListEntry = passengerList.add();
        String passengerFormOfAddress = passengerInfo.getFormOfAddress();
        if (passengerFormOfAddress != null && passengerFormOfAddress.length() != 0) {
            passengerListEntry.put((Object)"PASSFORM", (Object)passengerFormOfAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added PASSFORM = '{}' to PASSENGER_LIST", (Object)passengerFormOfAddress);
            }
        }
        if ((passengerName = passengerInfo.getName()) != null && passengerName.length() != 0) {
            passengerListEntry.put((Object)"PASSNAME", (Object)passengerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added PASSNAME = '{}' to PASSENGER_LIST", (Object)passengerName);
            }
        }
        if ((passengerDateOfBirth = passengerInfo.getDateOfBirth()) != null) {
            passengerListEntry.put((Object)"PASSBIRTH", (Object)passengerDateOfBirth);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added PASSBIRTH = '{}' to PASSENGER_LIST", (Object)passengerDateOfBirth);
            }
        }
        exchange.getIn().setBody((Object)request);
    }
}

