/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.apache.camel.Exchange;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.fusesource.sap.example.bean.FlightConnectionInfo;
import org.fusesource.sap.example.bean.FlightHop;
import org.fusesource.sap.example.bean.PriceInfo;
import org.fusesource.sap.example.bean.SeatAvailibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnFlightConnectionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ReturnFlightConnectionInfo.class);

    public void createFlightConnectionInfo(Exchange exchange) throws Exception {
        Structure flightConnectionGetDetailResponse = (Structure)exchange.getIn().getBody(Structure.class);
        if (flightConnectionGetDetailResponse == null) {
            throw new Exception("No Flight Connection Get Detail Response");
        }
        FlightConnectionInfo flightConnectionInfo = new FlightConnectionInfo();
        Structure connectionData = (Structure)flightConnectionGetDetailResponse.get((Object)"CONNECTION_DATA", Structure.class);
        if (connectionData != null) {
            Integer flightTime;
            Date arrivalDate;
            Date arrivalTime;
            Date departureTime;
            String numberOfHops;
            String arrivalCity;
            String arrivalAirport;
            String departureCity;
            String departureAirport;
            Date departureDate;
            String flightConnectionNumber;
            String travelAgencyNumber = (String)connectionData.get((Object)"AGENCYNUM", String.class);
            if (travelAgencyNumber != null) {
                flightConnectionInfo.setTravelAgencyNumber(travelAgencyNumber);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set travel agency number = '{}' in flight connection info", (Object)travelAgencyNumber);
                }
            }
            if ((flightConnectionNumber = (String)connectionData.get((Object)"FLIGHTCONN", String.class)) != null) {
                flightConnectionInfo.setFlightConnectionNumber(flightConnectionNumber);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set flight connection number = '{}' in flight connection info", (Object)flightConnectionNumber);
                }
            }
            if ((departureDate = (Date)connectionData.get((Object)"FLIGHTDATE", Date.class)) != null) {
                flightConnectionInfo.setDepartureDate(departureDate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set depature date = '{}' in flight connection info", (Object)departureDate);
                }
            }
            if ((departureAirport = (String)connectionData.get((Object)"AIRPORTFR", String.class)) != null) {
                flightConnectionInfo.setDepartureAirport(departureAirport);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure airport = '{}' in flight connection info", (Object)departureAirport);
                }
            }
            if ((departureCity = (String)connectionData.get((Object)"CITYFROM", String.class)) != null) {
                flightConnectionInfo.setDepartureCity(departureCity);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure city = '{}' in flight connection info", (Object)departureCity);
                }
            }
            if ((arrivalAirport = (String)connectionData.get((Object)"AIRPORTTO", String.class)) != null) {
                flightConnectionInfo.setArrivalAirport(arrivalAirport);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival airport = '{}' in flight connection info", (Object)arrivalAirport);
                }
            }
            if ((arrivalCity = (String)connectionData.get((Object)"CITYTO", String.class)) != null) {
                flightConnectionInfo.setArrivalCity(arrivalCity);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival city = '{}' in flight connection info", (Object)arrivalCity);
                }
            }
            if ((numberOfHops = (String)connectionData.get((Object)"NUMHOPS", String.class)) != null) {
                flightConnectionInfo.setNumberOfHops(numberOfHops);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set number of hops = '{}' in flight connection info", (Object)numberOfHops);
                }
            }
            if ((departureTime = (Date)connectionData.get((Object)"DEPTIME", Date.class)) != null) {
                flightConnectionInfo.setDepartureTime(departureTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure time = '{}' in flight connection info", (Object)departureTime);
                }
            }
            if ((arrivalTime = (Date)connectionData.get((Object)"ARRTIME", Date.class)) != null) {
                flightConnectionInfo.setArrivalTime(arrivalTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival time = '{}' in flight connection info", (Object)arrivalTime);
                }
            }
            if ((arrivalDate = (Date)connectionData.get((Object)"ARRDATE", Date.class)) != null) {
                flightConnectionInfo.setArrivalDate(arrivalDate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival date = '{}' in flight connection info", (Object)arrivalDate);
                }
            }
            if ((flightTime = (Integer)connectionData.get((Object)"FLIGHTTIME", Integer.class)) != null) {
                flightConnectionInfo.setFlightTime(flightTime.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set flight time = '{}' in flight connection info", (Object)flightTime);
                }
            }
        }
        Table hopList = (Table)flightConnectionGetDetailResponse.get((Object)"FLIGHT_HOP_LIST", Table.class);
        ArrayList<FlightHop> flightHopList = new ArrayList<FlightHop>();
        for (Structure hop : hopList) {
            String aircraftType;
            Date arrivalTime;
            Date arrivalDate;
            Date departureTime;
            Date departureDate;
            String arrivalCountryIso;
            String arrivalCountry;
            String arrivalCity;
            String arrivalAirport;
            String departureCountryIso;
            String departureCountry;
            String depatureCity;
            String depatureAirport;
            String flightConnectionNumber;
            String airlineName;
            String airlineCode;
            FlightHop flightHop = new FlightHop();
            String hopNumber = (String)hop.get((Object)"HOP", String.class);
            if (hopNumber != null) {
                flightHop.setHopNumber(hopNumber);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set hop number = '{}' in flight hop", (Object)hopNumber);
                }
            }
            if ((airlineCode = (String)hop.get((Object)"AIRLINEID", String.class)) != null) {
                flightHop.setAirlineCode(airlineCode);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set airline code = '{}' in flight hop", (Object)airlineCode);
                }
            }
            if ((airlineName = (String)hop.get((Object)"AIRLINE", String.class)) != null) {
                flightHop.setAirlineName(airlineName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set airline name = '{}' in flight hop", (Object)airlineName);
                }
            }
            if ((flightConnectionNumber = (String)hop.get((Object)"CONNECTID", String.class)) != null) {
                flightHop.setFlightConnectionNumber(flightConnectionNumber);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set flight connection number = '{}' in flight hop", (Object)flightConnectionNumber);
                }
            }
            if ((depatureAirport = (String)hop.get((Object)"AIRPORTFR", String.class)) != null) {
                flightHop.setDepatureAirport(depatureAirport);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure airport = '{}' in flight hop", (Object)depatureAirport);
                }
            }
            if ((depatureCity = (String)hop.get((Object)"CITYFROM", String.class)) != null) {
                flightHop.setDepatureCity(depatureCity);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure city = '{}' in flight hop", (Object)depatureCity);
                }
            }
            if ((departureCountry = (String)hop.get((Object)"CTRYFR", String.class)) != null) {
                flightHop.setDepartureCountry(departureCountry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure country = '{}' in flight hop", (Object)departureCountry);
                }
            }
            if ((departureCountryIso = (String)hop.get((Object)"CTRYFR_ISO", String.class)) != null) {
                flightHop.setDepartureCountryIso(departureCountryIso);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure iso country code = '{}' in flight hop", (Object)departureCountryIso);
                }
            }
            if ((arrivalAirport = (String)hop.get((Object)"AIRPORTTO", String.class)) != null) {
                flightHop.setArrivalAirport(arrivalAirport);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival airport = '{}' in flight hop", (Object)arrivalAirport);
                }
            }
            if ((arrivalCity = (String)hop.get((Object)"CITYTO", String.class)) != null) {
                flightHop.setArrivalCity(arrivalCity);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival city = '{}' in flight hop", (Object)arrivalCity);
                }
            }
            if ((arrivalCountry = (String)hop.get((Object)"CTRYTO", String.class)) != null) {
                flightHop.setArrivalCountry(arrivalCountry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival country = '{}' in flight hop", (Object)arrivalCountry);
                }
            }
            if ((arrivalCountryIso = (String)hop.get((Object)"CTRYTO_ISO", String.class)) != null) {
                flightHop.setArrivalCountryIso(arrivalCountryIso);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival iso country code = '{}' in flight hop", (Object)arrivalCountryIso);
                }
            }
            if ((departureDate = (Date)hop.get((Object)"DEPDATE", Date.class)) != null) {
                flightHop.setDepatureDate(departureDate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure date = '{}' in flight hop", (Object)departureDate);
                }
            }
            if ((departureTime = (Date)hop.get((Object)"DEPTIME", Date.class)) != null) {
                flightHop.setDepatureTime(departureTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set departure time = '{}' in flight hop", (Object)departureTime);
                }
            }
            if ((arrivalDate = (Date)hop.get((Object)"ARRDATE", Date.class)) != null) {
                flightHop.setArrivalDate(arrivalDate);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival date = '{}' in flight hop", (Object)arrivalDate);
                }
            }
            if ((arrivalTime = (Date)hop.get((Object)"ARRTIME", Date.class)) != null) {
                flightHop.setArrivalTime(arrivalTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set arrival time = '{}' in flight hop", (Object)arrivalTime);
                }
            }
            if ((aircraftType = (String)hop.get((Object)"PLANETYPE", String.class)) != null) {
                flightHop.setAircraftType(aircraftType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set aircraft type = '{}' in flight hop", (Object)aircraftType);
                }
            }
            flightHopList.add(flightHop);
        }
        flightConnectionInfo.setFlightHopList(flightHopList);
        Table availibilityList = (Table)flightConnectionGetDetailResponse.get((Object)"AVAILIBILITY", Table.class);
        ArrayList<SeatAvailibility> seatAvailiblityList = new ArrayList<SeatAvailibility>();
        for (Structure availibility : availibilityList) {
            Integer firstClassFreeSeats;
            Integer firstClassClassSeatCapacity;
            Integer businessClassFreeSeats;
            Integer businessClassSeatCapacity;
            Integer economyClassFreeSeats;
            Integer economyClassSeatCapacity;
            SeatAvailibility seatAvailiblity = new SeatAvailibility();
            String hopNumber = (String)availibility.get((Object)"HOP", String.class);
            if (hopNumber != null) {
                seatAvailiblity.setHopNumber(hopNumber);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set hop number = '{}' in seat availibility", (Object)hopNumber);
                }
            }
            if ((economyClassSeatCapacity = (Integer)availibility.get((Object)"ECONOMAX", Integer.class)) != null) {
                seatAvailiblity.setEconomyClassSeatCapacity(economyClassSeatCapacity.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set economy class seat capacity = '{}' in seat availibility", (Object)economyClassSeatCapacity);
                }
            }
            if ((economyClassFreeSeats = (Integer)availibility.get((Object)"ECONOFREE", Integer.class)) != null) {
                seatAvailiblity.setEconomyClassFreeSeats(economyClassFreeSeats.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set economy class free seats = '{}' in seat availibility", (Object)economyClassFreeSeats);
                }
            }
            if ((businessClassSeatCapacity = (Integer)availibility.get((Object)"BUSINMAX", Integer.class)) != null) {
                seatAvailiblity.setBusinessClassSeatCapacity(businessClassSeatCapacity.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set business class seat capacity = '{}' in seat availibility", (Object)businessClassSeatCapacity);
                }
            }
            if ((businessClassFreeSeats = (Integer)availibility.get((Object)"BUSINFREE", Integer.class)) != null) {
                seatAvailiblity.setBusinessClassFreeSeats(businessClassFreeSeats.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set business class free seats = '{}' in seat availibility", (Object)businessClassFreeSeats);
                }
            }
            if ((firstClassClassSeatCapacity = (Integer)availibility.get((Object)"FIRSTMAX", Integer.class)) != null) {
                seatAvailiblity.setFirstClassClassSeatCapacity(firstClassClassSeatCapacity.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set first class seat capacity = '{}' in seat availibility", (Object)firstClassClassSeatCapacity);
                }
            }
            if ((firstClassFreeSeats = (Integer)availibility.get((Object)"FIRSTFREE", Integer.class)) != null) {
                seatAvailiblity.setFirstClassFreeSeats(firstClassFreeSeats.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set first class free seats = '{}' in seat availibility", (Object)firstClassFreeSeats);
                }
            }
            seatAvailiblityList.add(seatAvailiblity);
        }
        flightConnectionInfo.setSeatAvailibilityList(seatAvailiblityList);
        Structure prices = (Structure)flightConnectionGetDetailResponse.get((Object)"PRICE_INFO", Structure.class);
        if (prices != null) {
            String currencyIso;
            String currency;
            BigDecimal flightTaxes;
            BigDecimal firstClassSmallChildAirfare;
            BigDecimal firstClassChildAirfare;
            BigDecimal firstClassAirfare;
            BigDecimal businessClassSmallChildAirfare;
            BigDecimal businessClassChildAirfare;
            BigDecimal businessClassAirfare;
            BigDecimal economyClassSmallChildAirfare;
            BigDecimal economyClassChildAirfare;
            PriceInfo priceInfo = new PriceInfo();
            BigDecimal economyClassAirfare = (BigDecimal)prices.get((Object)"PRICE_ECO1", BigDecimal.class);
            if (economyClassAirfare != null) {
                priceInfo.setEconomyClassAirfare(economyClassAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set economy class airfare = '{}' in seat availibility", (Object)economyClassAirfare);
                }
            }
            if ((economyClassChildAirfare = (BigDecimal)prices.get((Object)"PRICE_ECO2", BigDecimal.class)) != null) {
                priceInfo.setEconomyClassChildAirfare(economyClassChildAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set economy class child airfare = '{}' in seat availibility", (Object)economyClassChildAirfare);
                }
            }
            if ((economyClassSmallChildAirfare = (BigDecimal)prices.get((Object)"PRICE_ECO3", BigDecimal.class)) != null) {
                priceInfo.setEconomyClassSmallChildAirfare(economyClassSmallChildAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set economy class small child airfare = '{}' in seat availibility", (Object)economyClassSmallChildAirfare);
                }
            }
            if ((businessClassAirfare = (BigDecimal)prices.get((Object)"PRICE_BUS1", BigDecimal.class)) != null) {
                priceInfo.setBusinessClassAirfare(businessClassAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set business class airfare = '{}' in seat availibility", (Object)businessClassAirfare);
                }
            }
            if ((businessClassChildAirfare = (BigDecimal)prices.get((Object)"PRICE_BUS2", BigDecimal.class)) != null) {
                priceInfo.setBusinessClassChildAirfare(businessClassChildAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set business class child airfare = '{}' in seat availibility", (Object)businessClassChildAirfare);
                }
            }
            if ((businessClassSmallChildAirfare = (BigDecimal)prices.get((Object)"PRICE_BUS3", BigDecimal.class)) != null) {
                priceInfo.setBusinessClassSmallChildAirfare(businessClassSmallChildAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set business class small child airfare = '{}' in seat availibility", (Object)businessClassSmallChildAirfare);
                }
            }
            if ((firstClassAirfare = (BigDecimal)prices.get((Object)"PRICE_FST1", BigDecimal.class)) != null) {
                priceInfo.setBusinessClassAirfare(firstClassAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set first class airfare = '{}' in seat availibility", (Object)firstClassAirfare);
                }
            }
            if ((firstClassChildAirfare = (BigDecimal)prices.get((Object)"PRICE_FST2", BigDecimal.class)) != null) {
                priceInfo.setBusinessClassChildAirfare(firstClassChildAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set first class child airfare = '{}' in seat availibility", (Object)firstClassChildAirfare);
                }
            }
            if ((firstClassSmallChildAirfare = (BigDecimal)prices.get((Object)"PRICE_FST3", BigDecimal.class)) != null) {
                priceInfo.setBusinessClassSmallChildAirfare(firstClassSmallChildAirfare.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set first class small child airfare = '{}' in seat availibility", (Object)firstClassSmallChildAirfare);
                }
            }
            if ((flightTaxes = (BigDecimal)prices.get((Object)"TAX", BigDecimal.class)) != null) {
                priceInfo.setFlightTaxes(flightTaxes.toString());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set flight taxes = '{}' in seat availibility", (Object)flightTaxes);
                }
            }
            if ((currency = (String)prices.get((Object)"CURR", String.class)) != null) {
                priceInfo.setCurrency(currency);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set local currency = '{}' in seat availibility", (Object)currency);
                }
            }
            if ((currencyIso = (String)prices.get((Object)"CURR_ISO", String.class)) != null) {
                priceInfo.setCurrencyIso(currencyIso);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set local currency iso code = '{}' in seat availibility", (Object)currencyIso);
                }
            }
            flightConnectionInfo.setPriceInfo(priceInfo);
        }
        exchange.getIn().setHeader("flightConnectionInfo", (Object)flightConnectionInfo);
    }
}

