/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import org.apache.camel.Exchange;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.fusesource.sap.example.bean.FlightCustomerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnFlightCustomerInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ReturnFlightCustomerInfo.class);

    public void createFlightCustomerInfo(Exchange exchange) throws Exception {
        String email;
        String phone;
        String region;
        String countryIso;
        String country;
        String city;
        String postalCode;
        String poBox;
        String street;
        String formOfAddress;
        String customerName;
        Structure flightCustomerGetListResponse = (Structure)exchange.getIn().getBody(Structure.class);
        if (flightCustomerGetListResponse == null) {
            throw new Exception("No Flight Customer Get List Response");
        }
        Table bapiReturn = (Table)flightCustomerGetListResponse.get((Object)"RETURN", Table.class);
        Structure bapiReturnEntry = (Structure)bapiReturn.get(0);
        if (!((String)bapiReturnEntry.get((Object)"TYPE", String.class)).equals("S")) {
            String message = (String)bapiReturnEntry.get((Object)"MESSAGE", String.class);
            throw new Exception("BAPI call failed: " + message);
        }
        Table customerList = (Table)flightCustomerGetListResponse.get((Object)"CUSTOMER_LIST", Table.class);
        if (customerList == null || customerList.size() == 0) {
            throw new Exception("No Customer Info.");
        }
        Structure customer = (Structure)customerList.get(0);
        FlightCustomerInfo flightCustomerInfo = new FlightCustomerInfo();
        String customerId = (String)customer.get((Object)"CUSTOMERID", String.class);
        if (customerId != null) {
            flightCustomerInfo.setCustomerNumber(customerId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set customer number = '{}' in flight customer info", (Object)customerId);
            }
        }
        if ((customerName = (String)customer.get((Object)"CUSTNAME", String.class)) != null) {
            flightCustomerInfo.setName(customerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set customer name = '{}' in flight customer info", (Object)customerName);
            }
        }
        if ((formOfAddress = (String)customer.get((Object)"FORM", String.class)) != null) {
            flightCustomerInfo.setFormOfAddress(formOfAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set form of address = '{}' in flight customer info", (Object)formOfAddress);
            }
        }
        if ((street = (String)customer.get((Object)"STREET", String.class)) != null) {
            flightCustomerInfo.setStreet(street);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set street = '{}' in flight customer info", (Object)street);
            }
        }
        if ((poBox = (String)customer.get((Object)"POBOX", String.class)) != null) {
            flightCustomerInfo.setPoBox(poBox);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set PO box = '{}' in flight customer info", (Object)poBox);
            }
        }
        if ((postalCode = (String)customer.get((Object)"POSTCODE", String.class)) != null) {
            flightCustomerInfo.setPostalCode(postalCode);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set postal code = '{}' in flight customer info", (Object)postalCode);
            }
        }
        if ((city = (String)customer.get((Object)"CITY", String.class)) != null) {
            flightCustomerInfo.setCity(city);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set city = '{}' in flight customer info", (Object)city);
            }
        }
        if ((country = (String)customer.get((Object)"COUNTR", String.class)) != null) {
            flightCustomerInfo.setCountry(country);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set country = '{}' in flight customer info", (Object)country);
            }
        }
        if ((countryIso = (String)customer.get((Object)"COUNTR_ISO", String.class)) != null) {
            flightCustomerInfo.setCountryIso(countryIso);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set iso country code = '{}' in flight customer info", (Object)countryIso);
            }
        }
        if ((region = (String)customer.get((Object)"REGION", String.class)) != null) {
            flightCustomerInfo.setRegion(region);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set region = '{}' in flight customer info", (Object)region);
            }
        }
        if ((phone = (String)customer.get((Object)"PHONE", String.class)) != null) {
            flightCustomerInfo.setPhone(phone);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set phone = '{}' in flight customer info", (Object)phone);
            }
        }
        if ((email = (String)customer.get((Object)"EMAIL", String.class)) != null) {
            flightCustomerInfo.setEmail(email);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set email = '{}' in flight customer info", (Object)email);
            }
        }
        exchange.getIn().setHeader("flightCustomerInfo", (Object)flightCustomerInfo);
    }
}

