/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.model.rfc.Table;
import org.fusesource.sap.example.bean.FlightConnectionInfo;
import org.fusesource.sap.example.bean.FlightHop;
import org.fusesource.sap.example.bean.PassengerInfo;
import org.fusesource.sap.example.jaxb.BookFlightResponse;
import org.fusesource.sap.example.jaxb.ConnectionInfo;
import org.fusesource.sap.example.jaxb.ConnectionInfoTable;
import org.fusesource.sap.example.jaxb.FlightInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnFlightTripResponse {
    private static final Logger LOG = LoggerFactory.getLogger(ReturnFlightTripResponse.class);

    public void createFlightBookingResponse(Exchange exchange) throws Exception {
        FlightConnectionInfo flightConnectionInfo = (FlightConnectionInfo)exchange.getIn().getHeader("flightConnectionInfo", FlightConnectionInfo.class);
        PassengerInfo passengerInfo = (PassengerInfo)exchange.getIn().getHeader("passengerInfo", PassengerInfo.class);
        Structure flightTripCreateResponse = (Structure)exchange.getIn().getBody(Structure.class);
        if (flightTripCreateResponse == null) {
            throw new Exception("No Flight Trip Create Response");
        }
        Table bapiReturn = (Table)flightTripCreateResponse.get((Object)"RETURN", Table.class);
        Structure bapiReturnEntry = (Structure)bapiReturn.get(0);
        if (!((String)bapiReturnEntry.get((Object)"TYPE", String.class)).equals("S")) {
            String message = (String)bapiReturnEntry.get((Object)"MESSAGE", String.class);
            throw new Exception("BAPI call failed: " + message);
        }
        BookFlightResponse response = new BookFlightResponse();
        String tripNumber = (String)flightTripCreateResponse.get((Object)"TRIPNUMBER", String.class);
        if (tripNumber != null) {
            response.setTripNumber(tripNumber);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TRIPNUMBER = '{}' to request", (Object)tripNumber);
            }
        } else {
            throw new Exception("No Flight Booking Trip Number");
        }
        Structure ticketPrice = (Structure)flightTripCreateResponse.get((Object)"TICKET_PRICE", Structure.class);
        if (ticketPrice != null) {
            BigDecimal tripPrice = (BigDecimal)ticketPrice.get((Object)"TRIPPRICE", BigDecimal.class);
            response.setTicketPrice(tripPrice);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TICKET_PRICE = '{}' to request", (Object)tripPrice);
            }
            BigDecimal tripTax = (BigDecimal)ticketPrice.get((Object)"TRIPTAX", BigDecimal.class);
            response.setTicketTax(tripTax);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added TICKET_TAX = '{}' to request", (Object)tripTax);
            }
            String currency = (String)ticketPrice.get((Object)"CURR", String.class);
            response.setCurrency(currency);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added CURRENCY = '{}' to request", (Object)currency);
            }
        } else {
            throw new Exception("No Flight Booking Ticket Price");
        }
        response.setPassengerFormOfAddress(passengerInfo.getFormOfAddress());
        response.setPassengerName(passengerInfo.getName());
        response.setPassengerDateOfBirth(passengerInfo.getDateOfBirth());
        FlightInfo flightInfo = new FlightInfo();
        flightInfo.setFlightTime(flightConnectionInfo.getFlightTime());
        flightInfo.setCityFrom(flightConnectionInfo.getDepartureCity());
        flightInfo.setDepartureDate(flightConnectionInfo.getDepartureDate());
        flightInfo.setDepartureTime(flightConnectionInfo.getDepartureTime());
        flightInfo.setCityTo(flightConnectionInfo.getArrivalCity());
        flightInfo.setArrivalDate(flightConnectionInfo.getArrivalDate());
        flightInfo.setArrivalTime(flightConnectionInfo.getArrivalTime());
        response.setFlightInfo(flightInfo);
        ConnectionInfoTable connectionInfoTable = new ConnectionInfoTable();
        ArrayList<ConnectionInfo> rows = new ArrayList<ConnectionInfo>();
        for (FlightHop flightHop : flightConnectionInfo.getFlightHopList()) {
            ConnectionInfo connection = new ConnectionInfo();
            connection.setConnectionId(flightHop.getHopNumber());
            connection.setAirline(flightHop.getAirlineName());
            connection.setPlaneType(flightHop.getAircraftType());
            connection.setCityFrom(flightHop.getDepatureCity());
            connection.setDepartureDate(flightHop.getDepatureDate());
            connection.setDepartureTime(flightHop.getDepatureTime());
            connection.setCityTo(flightHop.getArrivalCity());
            connection.setArrivalDate(flightHop.getArrivalDate());
            connection.setArrivalTime(flightHop.getArrivalTime());
            rows.add(connection);
        }
        connectionInfoTable.setRows(rows);
        response.setConnectionInfo(connectionInfoTable);
        exchange.getIn().setBody((Object)response);
    }
}

