/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.sap.example.processor;

import java.util.Date;
import org.apache.camel.Exchange;
import org.fusesource.sap.example.bean.PassengerInfo;
import org.fusesource.sap.example.jaxb.BookFlightRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnPassengerInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ReturnPassengerInfo.class);

    public void createPassengerInfo(Exchange exchange) {
        Date passengerDateOfBirth;
        String passengerName;
        BookFlightRequest bookFlightRequest = (BookFlightRequest)exchange.getIn().getBody(BookFlightRequest.class);
        PassengerInfo passengerInfo = new PassengerInfo();
        String passengerFormOfAddress = bookFlightRequest.getPassengerFormOfAddress();
        if (passengerFormOfAddress != null) {
            passengerInfo.setFormOfAddress(passengerFormOfAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set passenger form of address = '{}' in passenger info", (Object)passengerFormOfAddress);
            }
        }
        if ((passengerName = bookFlightRequest.getPassengerName()) != null) {
            passengerInfo.setName(passengerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set passenger name = '{}' in passenger info", (Object)passengerName);
            }
        }
        if ((passengerDateOfBirth = bookFlightRequest.getPassengerDateOfBirth()) != null) {
            passengerInfo.setDateOfBirth(passengerDateOfBirth);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set passenger date of birth = '{}' in passenger info", (Object)passengerDateOfBirth);
            }
        }
        exchange.getIn().setHeader("passengerInfo", (Object)passengerInfo);
    }
}

