/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.jms.JMSException;
import org.apache.qpid.amqp_1_0.jms.ConnectionMetaData;

public class ConnectionMetaDataImpl
implements ConnectionMetaData {
    private static final int JMS_MAJOR_VERSION = 1;
    private static final int JMS_MINOR_VERSION = 1;
    private static final int PROVIDER_MAJOR_VERSION = 1;
    private static final int PROVIDER_MINOR_VERSION = 0;
    private final int _amqpMajorVersion;
    private final int _amqpMinorVersion;
    private final int _amqpRevisionVersion;
    private static final Collection<String> _jmsxProperties = Arrays.asList("JMSXGroupID", "JMSXGroupSeq");

    public ConnectionMetaDataImpl(int amqpMajorVersion, int amqpMinorVersion, int amqpRevisionVersion) {
        this._amqpMajorVersion = amqpMajorVersion;
        this._amqpMinorVersion = amqpMinorVersion;
        this._amqpRevisionVersion = amqpRevisionVersion;
    }

    public String getJMSVersion() throws JMSException {
        return this.getJMSMajorVersion() + "." + this.getJMSMinorVersion();
    }

    public int getJMSMajorVersion() throws JMSException {
        return 1;
    }

    public int getJMSMinorVersion() throws JMSException {
        return 1;
    }

    public String getJMSProviderName() throws JMSException {
        return "AMQP.ORG";
    }

    public String getProviderVersion() throws JMSException {
        return this.getProviderMajorVersion() + "." + this.getProviderMinorVersion();
    }

    public int getProviderMajorVersion() throws JMSException {
        return 1;
    }

    public int getProviderMinorVersion() throws JMSException {
        return 0;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        return Collections.enumeration(_jmsxProperties);
    }

    public int getAMQPMajorVersion() {
        return this._amqpMajorVersion;
    }

    public int getAMQPMinorVersion() {
        return this._amqpMinorVersion;
    }

    public int getAMQPRevisionVersion() {
        return this._amqpRevisionVersion;
    }
}

