/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.UUID;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.qpid.amqp_1_0.client.ConnectionClosedException;
import org.apache.qpid.amqp_1_0.client.LinkDetachedException;
import org.apache.qpid.amqp_1_0.client.Sender;
import org.apache.qpid.amqp_1_0.jms.Message;
import org.apache.qpid.amqp_1_0.jms.MessageProducer;
import org.apache.qpid.amqp_1_0.jms.MessageRejectedException;
import org.apache.qpid.amqp_1_0.jms.QueueSender;
import org.apache.qpid.amqp_1_0.jms.TemporaryDestination;
import org.apache.qpid.amqp_1_0.jms.TopicPublisher;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class MessageProducerImpl
implements MessageProducer,
QueueSender,
TopicPublisher {
    private boolean _disableMessageID;
    private boolean _disableMessageTimestamp;
    private int _deliveryMode = 2;
    private int _priority = 4;
    private long _timeToLive;
    private DestinationImpl _destination;
    private SessionImpl _session;
    private Sender _sender;
    private boolean _closed;
    private boolean _syncPublish = Boolean.getBoolean("qpid.sync_publish");
    private long _syncPublishTimeout = Long.getLong("qpid.sync_publish_timeout", 30000L);

    protected MessageProducerImpl(Destination destination, SessionImpl session) throws JMSException {
        if (destination instanceof DestinationImpl) {
            this._destination = (DestinationImpl)destination;
        } else if (destination != null) {
            throw new InvalidDestinationException("Invalid Destination Class" + destination.getClass().getName());
        }
        this._session = session;
        if (this._destination != null) {
            try {
                this._sender = this._session.getClientSession().createSender(this._session.toAddress(this._destination));
            }
            catch (Sender.SenderCreationException e) {
                JMSException jmsEx = new JMSException(e.getMessage());
                jmsEx.initCause((Throwable)e);
                jmsEx.setLinkedException((Exception)((Object)e));
                throw jmsEx;
            }
            catch (ConnectionClosedException e) {
                JMSException jmsEx = new JMSException(e.getMessage());
                jmsEx.initCause((Throwable)e);
                jmsEx.setLinkedException((Exception)((Object)e));
                throw jmsEx;
            }
            this._sender.setRemoteErrorListener(new Runnable(){

                public void run() {
                    try {
                        ExceptionListener exceptionListener = MessageProducerImpl.this._session.getConnection().getExceptionListener();
                        if (exceptionListener != null) {
                            Error receiverError = MessageProducerImpl.this._sender.getError();
                            exceptionListener.onException(new JMSException(receiverError.getDescription(), receiverError.getCondition().getValue().toString()));
                        }
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("Producer closed");
        }
    }

    public boolean getDisableMessageID() throws IllegalStateException {
        this.checkClosed();
        return this._disableMessageID;
    }

    public void setDisableMessageID(boolean disableMessageID) throws IllegalStateException {
        this.checkClosed();
        this._disableMessageID = disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws IllegalStateException {
        this.checkClosed();
        return this._disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws IllegalStateException {
        this.checkClosed();
        this._disableMessageTimestamp = disableMessageTimestamp;
    }

    public int getDeliveryMode() throws IllegalStateException {
        this.checkClosed();
        return this._deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) throws IllegalStateException {
        this.checkClosed();
        this._deliveryMode = deliveryMode;
    }

    public int getPriority() throws IllegalStateException {
        this.checkClosed();
        return this._priority;
    }

    public void setPriority(int priority) throws IllegalStateException {
        this.checkClosed();
        this._priority = priority;
    }

    public long getTimeToLive() throws IllegalStateException {
        this.checkClosed();
        return this._timeToLive;
    }

    public void setTimeToLive(long timeToLive) throws IllegalStateException {
        this.checkClosed();
        this._timeToLive = timeToLive;
    }

    public DestinationImpl getDestination() throws JMSException {
        this.checkClosed();
        return this._destination;
    }

    public void close() throws JMSException {
        try {
            if (!this._closed) {
                this._closed = true;
                if (this._sender != null) {
                    this._sender.close();
                }
            }
        }
        catch (Sender.SenderClosingException e) {
            JMSException jmsException = new JMSException("error closing");
            jmsException.setLinkedException((Exception)((Object)e));
            throw jmsException;
        }
    }

    public void send(javax.jms.Message message) throws JMSException {
        this.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(javax.jms.Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        if (this._sender == null) {
            throw new UnsupportedOperationException("No Destination provided");
        }
        if (this._destination instanceof TemporaryDestination && ((TemporaryDestination)((Object)this._destination)).isDeleted()) {
            throw new IllegalStateException("Destination is deleted");
        }
        MessageImpl msg = message instanceof Message ? (MessageImpl)message : this._session.convertMessage(message);
        msg.setJMSDeliveryMode(deliveryMode);
        msg.setJMSPriority(priority);
        msg.setJMSDestination(this._destination);
        long timestamp = 0L;
        if (!this.getDisableMessageTimestamp() || ttl != 0L) {
            timestamp = System.currentTimeMillis();
            msg.setJMSTimestamp(timestamp);
        }
        if (ttl != 0L) {
            msg.setTtl(UnsignedInteger.valueOf((long)ttl));
        } else {
            msg.setTtl(null);
        }
        if (!this.getDisableMessageID() && msg.getMessageId() == null) {
            Object messageId = this.generateMessageId();
            msg.setMessageId(messageId);
        }
        if (message != msg) {
            message.setJMSTimestamp(msg.getJMSTimestamp());
            message.setJMSMessageID(msg.getJMSMessageID());
            message.setJMSDeliveryMode(msg.getJMSDeliveryMode());
            message.setJMSPriority(msg.getJMSPriority());
            message.setJMSExpiration(msg.getJMSExpiration());
        }
        org.apache.qpid.amqp_1_0.client.Message clientMessage = new org.apache.qpid.amqp_1_0.client.Message(msg.getSections());
        DispositionAction action = null;
        if (this._syncPublish) {
            action = new DispositionAction(this._sender);
        }
        try {
            this._sender.send(clientMessage, this._session.getTxn(), (Sender.OutcomeAction)action);
        }
        catch (LinkDetachedException e) {
            InvalidDestinationException jmsException = new InvalidDestinationException("Sender has been closed");
            jmsException.setLinkedException((Exception)((Object)e));
            throw jmsException;
        }
        if (this._syncPublish && !action.wasAccepted(this._syncPublishTimeout + System.currentTimeMillis())) {
            throw new MessageRejectedException("Message was rejected");
        }
        if (this.getDestination() != null) {
            message.setJMSDestination((Destination)this.getDestination());
        }
    }

    public void send(Queue queue, javax.jms.Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, javax.jms.Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send((Destination)queue, message, deliveryMode, priority, ttl);
    }

    private Object generateMessageId() {
        UUID uuid = UUID.randomUUID();
        String messageIdString = uuid.toString();
        return this._session.getConnection().useBinaryMessageId() ? new Binary(messageIdString.getBytes()) : messageIdString;
    }

    public void send(Destination destination, javax.jms.Message message) throws JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.checkClosed();
        if (destination == null) {
            this.send(message, deliveryMode, priority, ttl);
        } else {
            if (this._destination != null) {
                throw new UnsupportedOperationException("Cannot use explicit destination pon non-anonymous producer");
            }
            if (!(destination instanceof DestinationImpl)) {
                throw new InvalidDestinationException("Invalid Destination Class" + destination.getClass().getName());
            }
            if (destination instanceof TemporaryDestination && ((TemporaryDestination)destination).isDeleted()) {
                throw new IllegalStateException("Destination has been deleted");
            }
            try {
                this._destination = (DestinationImpl)destination;
                this._sender = this._session.getClientSession().createSender(this._session.toAddress(this._destination));
                this.send(message, deliveryMode, priority, ttl);
                this._sender.close();
            }
            catch (Sender.SenderCreationException e) {
                JMSException jmsEx = new JMSException(e.getMessage());
                jmsEx.initCause((Throwable)e);
                jmsEx.setLinkedException((Exception)((Object)e));
                throw jmsEx;
            }
            catch (Sender.SenderClosingException e) {
                JMSException jmsEx = new JMSException(e.getMessage());
                jmsEx.initCause((Throwable)e);
                jmsEx.setLinkedException((Exception)((Object)e));
                throw jmsEx;
            }
            catch (ConnectionClosedException e) {
                JMSException jmsEx = new JMSException(e.getMessage());
                jmsEx.initCause((Throwable)e);
                jmsEx.setLinkedException((Exception)((Object)e));
                throw jmsEx;
            }
            finally {
                this._sender = null;
                this._destination = null;
            }
        }
    }

    public QueueImpl getQueue() throws JMSException {
        return (QueueImpl)this.getDestination();
    }

    public TopicImpl getTopic() throws JMSException {
        return (TopicImpl)this.getDestination();
    }

    public void publish(javax.jms.Message message) throws JMSException {
        this.send(message);
    }

    public void publish(javax.jms.Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(message, deliveryMode, priority, ttl);
    }

    public void publish(Topic topic, javax.jms.Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(Topic topic, javax.jms.Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send((Destination)topic, message, deliveryMode, priority, ttl);
    }

    private static class DispositionAction
    implements Sender.OutcomeAction {
        private final Sender _sender;
        private final Object _lock;
        private Outcome _outcome;

        public DispositionAction(Sender sender) {
            this._sender = sender;
            this._lock = sender.getEndpoint().getLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOutcome(Binary deliveryTag, Outcome outcome) {
            Object object = this._lock;
            synchronized (object) {
                this._outcome = outcome;
                this._lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean wasAccepted(long timeout) throws JMSException {
            Object object = this._lock;
            synchronized (object) {
                while (this._outcome == null && !this._sender.getEndpoint().isDetached()) {
                    try {
                        this._lock.wait(timeout - System.currentTimeMillis());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this._outcome == null) {
                    if (this._sender.getEndpoint().isDetached()) {
                        throw new JMSException("Link was detached");
                    }
                    throw new JMSException("Timed out waiting for message acceptance");
                }
                return this._outcome instanceof Accepted;
            }
        }
    }
}

