/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.qpid.amqp_1_0.client.AcknowledgeMode;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.jms.QueueBrowser;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.type.DistributionMode;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Filter;
import org.apache.qpid.amqp_1_0.type.messaging.JMSSelectorFilter;
import org.apache.qpid.amqp_1_0.type.messaging.StdDistMode;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class QueueBrowserImpl
implements QueueBrowser {
    private static final String JMS_SELECTOR = "jms-selector";
    private QueueImpl _queue;
    private String _selector;
    private final SessionImpl _session;
    private Map<Symbol, Filter> _filters;
    private HashSet<MessageEnumeration> _enumerations = new HashSet();
    private boolean _closed;

    QueueBrowserImpl(QueueImpl queue, String selector, SessionImpl session) throws JMSException {
        this._queue = queue;
        this._selector = selector;
        this._session = session;
        if (selector == null || selector.trim().equals("")) {
            this._filters = null;
        } else {
            this._filters = Collections.singletonMap(Symbol.valueOf((String)JMS_SELECTOR), new JMSSelectorFilter(this._selector));
            new MessageEnumeration().close();
        }
    }

    public QueueImpl getQueue() {
        return this._queue;
    }

    public String getMessageSelector() {
        return this._selector;
    }

    public Enumeration getEnumeration() throws JMSException {
        if (this._closed) {
            throw new IllegalStateException("Browser has been closed");
        }
        return new MessageEnumeration();
    }

    public void close() throws JMSException {
        this._closed = true;
        for (MessageEnumeration me : new ArrayList<MessageEnumeration>(this._enumerations)) {
            me.close();
        }
    }

    MessageImpl createJMSMessage(Message msg) {
        if (msg != null) {
            MessageImpl message = this._session.getMessageFactory().createMessage(this._queue, msg);
            message.setFromQueue(true);
            message.setFromTopic(false);
            return message;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MessageEnumeration
    implements Enumeration<MessageImpl> {
        private Receiver _receiver;
        private MessageImpl _nextElement;
        private boolean _needNext = true;

        MessageEnumeration() throws JMSException {
            try {
                this._receiver = QueueBrowserImpl.this._session.getClientSession().createReceiver(QueueBrowserImpl.this._session.toAddress(QueueBrowserImpl.this._queue), (DistributionMode)StdDistMode.COPY, AcknowledgeMode.AMO, null, false, QueueBrowserImpl.this._filters, null);
                this._receiver.setCredit(UnsignedInteger.valueOf((int)100), true);
            }
            catch (ConnectionErrorException e) {
                Error error = e.getRemoteError();
                if (AmqpError.INVALID_FIELD.equals(error.getCondition())) {
                    throw new InvalidSelectorException(e.getMessage());
                }
                throw new JMSException(e.getMessage(), error.getCondition().getValue().toString());
            }
            QueueBrowserImpl.this._enumerations.add(this);
        }

        public void close() {
            QueueBrowserImpl.this._enumerations.remove(this);
            this._receiver.close();
            this._receiver = null;
        }

        @Override
        public boolean hasMoreElements() {
            if (this._receiver == null) {
                return false;
            }
            if (this._needNext) {
                this._needNext = false;
                this._nextElement = QueueBrowserImpl.this.createJMSMessage(this._receiver.receive(0L));
                if (this._nextElement == null) {
                    this._receiver.drain();
                    this._receiver.drainWait();
                    this._nextElement = QueueBrowserImpl.this.createJMSMessage(this._receiver.receive(0L));
                    if (this._nextElement == null) {
                        this.close();
                    } else {
                        this._receiver.clearDrain();
                    }
                }
            }
            return this._nextElement != null;
        }

        @Override
        public MessageImpl nextElement() {
            if (this.hasMoreElements()) {
                MessageImpl message = this._nextElement;
                this._nextElement = null;
                this._needNext = true;
                return message;
            }
            throw new NoSuchElementException();
        }
    }
}

