/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.apache.qpid.amqp_1_0.client.Sender;
import org.apache.qpid.amqp_1_0.jms.MessageConsumer;
import org.apache.qpid.amqp_1_0.jms.TemporaryTopic;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicImpl;

public class TemporaryTopicImpl
extends TopicImpl
implements TemporaryTopic {
    private Sender _sender;
    private SessionImpl _session;
    private final Set<MessageConsumer> _consumers = Collections.synchronizedSet(new HashSet());
    private boolean _deleted;

    protected TemporaryTopicImpl(String address, Sender sender, SessionImpl session) {
        super(address);
        this._sender = sender;
        this._session = session;
        this._session.getConnection().addOnCloseTask(new ConnectionImpl.CloseTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClose() throws JMSException {
                TemporaryTopicImpl temporaryTopicImpl = TemporaryTopicImpl.this;
                synchronized (temporaryTopicImpl) {
                    TemporaryTopicImpl.this.close();
                }
            }
        });
    }

    public void delete() throws JMSException {
        if (!this._consumers.isEmpty()) {
            throw new IllegalStateException("Cannot delete destination as it has consumers");
        }
        this._deleted = true;
        this.close();
    }

    private void close() throws JMSException {
        if (this._sender != null) {
            try {
                this._sender.close();
                this._sender = null;
            }
            catch (Sender.SenderClosingException e) {
                JMSException jmsException = new JMSException(e.getMessage());
                jmsException.setLinkedException((Exception)((Object)e));
                throw jmsException;
            }
        }
    }

    public SessionImpl getSession() {
        return this._session;
    }

    public void addConsumer(MessageConsumer consumer) {
        this._consumers.add(consumer);
    }

    public void removeConsumer(MessageConsumer consumer) {
        this._consumers.remove(consumer);
    }

    public boolean isDeleted() {
        return this._deleted;
    }
}

