/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import org.apache.qpid.amqp_1_0.codec.CompoundWriter;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapWriter<V>
extends CompoundWriter<V> {
    private boolean onKey;

    public AbstractMapWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected byte getFourOctetEncodingCode() {
        return -47;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return -63;
    }

    @Override
    protected final int getCount() {
        return 2 * this.getMapCount();
    }

    protected abstract int getMapCount();

    @Override
    protected final boolean hasNext() {
        return this.onKey || this.hasMapNext();
    }

    protected abstract boolean hasMapNext();

    @Override
    protected final Object next() {
        this.onKey = !this.onKey;
        if (this.onKey) {
            return this.nextKey();
        }
        return this.nextValue();
    }

    protected abstract Object nextValue();

    protected abstract Object nextKey();

    @Override
    protected final void clear() {
        this.onKey = false;
        this.onClear();
    }

    protected abstract void onClear();

    @Override
    protected final void reset() {
        this.onKey = false;
        this.onReset();
    }

    protected abstract void onReset();
}

