/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanConstructor {
    private static final TypeConstructor<Boolean> TRUE_INSTANCE = new TypeConstructor<Boolean>(){

        @Override
        public Boolean construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
            return Boolean.TRUE;
        }
    };
    private static final TypeConstructor<Boolean> FALSE_INSTANCE = new TypeConstructor<Boolean>(){

        @Override
        public Boolean construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
            return Boolean.FALSE;
        }
    };
    private static final TypeConstructor<Boolean> BYTE_INSTANCE = new TypeConstructor<Boolean>(){

        @Override
        public Boolean construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
            if (in.hasRemaining()) {
                byte b = in.get();
                return b != 0;
            }
            Error error = new Error();
            error.setCondition(ConnectionError.FRAMING_ERROR);
            error.setDescription("Cannot construct boolean: insufficient input data");
            throw new AmqpErrorException(error);
        }
    };

    public static TypeConstructor<Boolean> getTrueInstance() {
        return TRUE_INSTANCE;
    }

    public static TypeConstructor<Boolean> getFalseInstance() {
        return FALSE_INSTANCE;
    }

    public static TypeConstructor<Boolean> getByteInstance() {
        return BYTE_INSTANCE;
    }
}

