/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteWriter
implements ValueWriter<Byte> {
    private int _written = 2;
    private byte _value;
    private static ValueWriter.Factory<Byte> FACTORY = new ValueWriter.Factory<Byte>(){

        @Override
        public ValueWriter<Byte> newInstance(ValueWriter.Registry registry) {
            return new ByteWriter();
        }
    };

    @Override
    public int writeToBuffer(ByteBuffer buffer) {
        switch (this._written) {
            case 0: {
                if (!buffer.hasRemaining()) break;
                buffer.put((byte)81);
            }
            case 1: {
                if (buffer.hasRemaining()) {
                    buffer.put(this._value);
                    this._written = 2;
                    break;
                }
                this._written = 1;
            }
        }
        return 2;
    }

    @Override
    public void setValue(Byte value) {
        this._written = 0;
        this._value = value;
    }

    @Override
    public boolean isComplete() {
        return this._written == 2;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Byte.class, FACTORY);
    }
}

