/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.TypeConstructor;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecimalConstructor
implements TypeConstructor<BigDecimal> {
    private static final DecimalConstructor DECIMAL_32 = new DecimalConstructor(){

        public BigDecimal construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
            if (in.remaining() < 4) {
                throw new AmqpErrorException(ConnectionError.FRAMING_ERROR, "Cannot construct decimal32: insufficient input data", new Object[0]);
            }
            int val = in.getInt();
            return DecimalConstructor.constructFrom32(val);
        }
    };
    private static final DecimalConstructor DECIMAL_64 = new DecimalConstructor(){

        public BigDecimal construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
            if (in.remaining() < 8) {
                throw new AmqpErrorException(ConnectionError.FRAMING_ERROR, "Cannot construct decimal64: insufficient input data", new Object[0]);
            }
            long val = in.getLong();
            return DecimalConstructor.constructFrom64(val);
        }
    };
    private static final DecimalConstructor DECIMAL_128 = new DecimalConstructor(){

        public BigDecimal construct(ByteBuffer in, ValueHandler handler) throws AmqpErrorException {
            if (in.remaining() < 16) {
                throw new AmqpErrorException(ConnectionError.FRAMING_ERROR, "Cannot construct decimal128: insufficient input data", new Object[0]);
            }
            long high = in.getLong();
            long low = in.getLong();
            return DecimalConstructor.constructFrom128(high, low);
        }
    };
    private static final BigDecimal TWO_TO_THE_SIXTY_FOUR = new BigDecimal(2).pow(64);

    private static BigDecimal constructFrom128(long high, long low) {
        int sign = (high & Long.MIN_VALUE) == 0L ? 1 : -1;
        int exponent = 0;
        long significand = high;
        if ((high & 0x6000000000000000L) != 0x6000000000000000L) {
            exponent = (int)((high & 0x7FFE000000000000L) >> 49) - 6176;
            significand = high & 0x1FFFFFFFFFFFFL;
        } else if ((high & 0x7800000000000000L) != 0x7800000000000000L) {
            exponent = (int)((high & 0x1FFF800000000000L) >> 47) - 6176;
            significand = 0x7FFFFFFFFFFFL & high | 0x4000000000000L;
        } else {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(significand).multiply(TWO_TO_THE_SIXTY_FOUR);
        bigDecimal = low >= 0L ? bigDecimal.add(new BigDecimal(low)) : bigDecimal.add(TWO_TO_THE_SIXTY_FOUR.add(new BigDecimal(low)));
        if ((high & Long.MIN_VALUE) != 0L) {
            bigDecimal = bigDecimal.negate();
        }
        bigDecimal = bigDecimal.scaleByPowerOfTen(exponent);
        return bigDecimal;
    }

    private static BigDecimal constructFrom64(long val) {
        int sign = (val & Long.MIN_VALUE) == 0L ? 1 : -1;
        int exponent = 0;
        long significand = val;
        if ((val & 0x6000000000000000L) != 0x6000000000000000L) {
            exponent = (int)((val & 0x7FE0000000000000L) >> 53) - 398;
            significand = val & 0x1FFFFFFFFFFFFFL;
        } else if ((val & 0x7800000000000000L) != 0x7800000000000000L) {
            exponent = (int)((val & 0x1FF8000000000000L) >> 51) - 398;
            significand = 0x7FFFFFFFFFFFFL & val | 0x20000000000000L;
        } else {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal((long)sign * significand);
        bigDecimal = bigDecimal.scaleByPowerOfTen(exponent);
        return bigDecimal;
    }

    private static BigDecimal constructFrom32(int val) {
        int sign = (val & Integer.MIN_VALUE) == 0 ? 1 : -1;
        int exponent = 0;
        int significand = val;
        if ((val & 0x60000000) != 0x60000000) {
            exponent = ((val & 0x7F800000) >> 23) - 101;
            significand = val & Integer.MAX_VALUE;
        } else if ((val & 0x78000000) != 0x78000000) {
            exponent = ((val & 0x1FE00000) >> 21) - 101;
            significand = 0x1FFFFF & val | 0x800000;
        } else {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(sign * significand);
        bigDecimal = bigDecimal.scaleByPowerOfTen(exponent);
        return bigDecimal;
    }

    public static TypeConstructor getDecimal32Instance() {
        return DECIMAL_32;
    }

    public static TypeConstructor getDecimal64Instance() {
        return DECIMAL_64;
    }

    public static TypeConstructor getDecimal128Instance() {
        return DECIMAL_128;
    }
}

