/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.amqp_1_0.codec.BinaryString;
import org.apache.qpid.amqp_1_0.codec.ValueHandler;
import org.apache.qpid.amqp_1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;

public class StringTypeConstructor
extends VariableWidthTypeConstructor {
    private Charset _charSet;
    private BinaryString _defaultBinaryString = new BinaryString();
    private ValueCache<BinaryString, String> _cachedValues = new ValueCache(10);

    public static StringTypeConstructor getInstance(int i, Charset c) {
        return new StringTypeConstructor(i, c);
    }

    private StringTypeConstructor(int size, Charset c) {
        super(size);
        this._charSet = c;
    }

    public Object construct(ByteBuffer in, boolean isCopy, ValueHandler handler) throws AmqpErrorException {
        String str;
        int size = this.getSize() == 1 ? in.get() & 0xFF : in.getInt();
        int origPosition = in.position();
        this._defaultBinaryString.setData(in.array(), in.arrayOffset() + origPosition, size);
        BinaryString binaryStr = this._defaultBinaryString;
        boolean isFull = this._cachedValues.isFull();
        String string = str = isFull ? (String)this._cachedValues.remove(binaryStr) : (String)this._cachedValues.get(binaryStr);
        if (str == null) {
            ByteBuffer dup = in.duplicate();
            try {
                dup.limit(dup.position() + size);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("position: " + dup.position() + "size: " + size + " capacity: " + dup.capacity());
            }
            CharBuffer charBuf = this._charSet.decode(dup);
            str = charBuf.toString();
            byte[] data = new byte[size];
            in.get(data);
            binaryStr = new BinaryString(data, 0, size);
            this._cachedValues.put(binaryStr, str);
        } else if (isFull) {
            byte[] data = new byte[size];
            in.get(data);
            binaryStr = new BinaryString(data, 0, size);
            this._cachedValues.put(binaryStr, str);
        }
        in.position(origPosition + size);
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int _cacheSize;

        public ValueCache(int cacheSize) {
            this._cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this._cacheSize;
        }

        public boolean isFull() {
            return this.size() == this._cacheSize;
        }
    }
}

