/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ProtocolHandler;
import org.apache.qpid.amqp_1_0.framing.FrameHandler;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;

public class AMQPProtocolHeaderHandler
implements ProtocolHandler {
    private ConnectionEndpoint _connection;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 0;
    private State _state = State.AWAITING_MAJOR;

    public AMQPProtocolHeaderHandler(ConnectionEndpoint connection) {
        this._connection = connection;
    }

    public ProtocolHandler parse(ByteBuffer in) {
        while (in.hasRemaining() && this._state != State.ERROR) {
            switch (this._state) {
                case AWAITING_MAJOR: {
                    State state = this._state = in.get() == 1 ? State.AWAITING_MINOR : State.ERROR;
                    if (!in.hasRemaining()) break;
                }
                case AWAITING_MINOR: {
                    State state = this._state = in.get() == 0 ? State.AWAITING_MINOR : State.ERROR;
                    if (!in.hasRemaining()) break;
                }
                case AWAITING_REVISION: {
                    byte revision = in.get();
                    this._connection.protocolHeaderReceived((byte)1, (byte)0, revision);
                    FrameHandler handler = new FrameHandler(this._connection);
                    return handler.parse(in);
                }
            }
        }
        if (this._state == State.ERROR) {
            this._connection.invalidHeaderReceived();
        }
        return this;
    }

    public boolean isDone() {
        return this._state != State.ERROR && !this._connection.closedForInput();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        AWAITING_MAJOR,
        AWAITING_MINOR,
        AWAITING_REVISION,
        ERROR;

    }
}

