/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.messaging;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.codec.AMQPDescribedTypeRegistry;

public class SectionEncoderImpl
implements SectionEncoder {
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    private ValueWriter.Registry _registry;
    private int _totalSize = 0;
    private List<byte[]> _output = new ArrayList<byte[]>();
    private static final int DEFAULT_BUFFER_SIZE = 65536;
    private ByteBuffer _current;

    public SectionEncoderImpl(AMQPDescribedTypeRegistry describedTypeRegistry) {
        this._registry = describedTypeRegistry;
        this.reset();
    }

    public void reset() {
        this._totalSize = 0;
        this._output.clear();
        this._current = null;
    }

    public Binary getEncoding() {
        byte[] data = new byte[this._totalSize];
        int offset = 0;
        Iterator<byte[]> i$ = this._output.iterator();
        while (i$.hasNext()) {
            byte[] src;
            int length = (src = i$.next()).length;
            System.arraycopy(src, 0, data, offset, this._totalSize - offset < length ? this._totalSize - offset : length);
            offset += length;
        }
        return new Binary(data);
    }

    public void encodeObject(Object obj) {
        ValueWriter<Object> valueWriter = this._registry.getValueWriter(obj);
        valueWriter.setValue(obj);
        int size = valueWriter.writeToBuffer(EMPTY_BYTE_BUFFER);
        byte[] data = new byte[size];
        this._current = ByteBuffer.wrap(data);
        valueWriter.writeToBuffer(this._current);
        this._output.add(data);
        this._totalSize += size;
    }

    public void encodeRaw(byte[] data) {
        int length;
        int remaining;
        if (this._current == null) {
            byte[] buf = new byte[data.length];
            this._current = ByteBuffer.wrap(buf);
            this._output.add(buf);
        }
        if ((remaining = this._current.remaining()) < (length = data.length)) {
            this._current.put(data, 0, remaining);
            byte[] dst = new byte[length - remaining];
            this._output.add(dst);
            this._current = ByteBuffer.wrap(dst).put(data, remaining, length - remaining);
        } else {
            this._current.put(data);
        }
        this._totalSize += data.length;
    }
}

