/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.amqp_1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.framing.AMQFrame;
import org.apache.qpid.amqp_1_0.framing.SASLFrame;
import org.apache.qpid.amqp_1_0.transport.ConnectionEventListener;
import org.apache.qpid.amqp_1_0.transport.ConnectionState;
import org.apache.qpid.amqp_1_0.transport.Container;
import org.apache.qpid.amqp_1_0.transport.ErrorHandler;
import org.apache.qpid.amqp_1_0.transport.FrameOutputHandler;
import org.apache.qpid.amqp_1_0.transport.SASLEndpoint;
import org.apache.qpid.amqp_1_0.transport.SaslServerProvider;
import org.apache.qpid.amqp_1_0.transport.SessionEndpoint;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.FrameBody;
import org.apache.qpid.amqp_1_0.type.SaslFrameBody;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.UnsignedShort;
import org.apache.qpid.amqp_1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.amqp_1_0.type.security.SaslChallenge;
import org.apache.qpid.amqp_1_0.type.security.SaslCode;
import org.apache.qpid.amqp_1_0.type.security.SaslInit;
import org.apache.qpid.amqp_1_0.type.security.SaslMechanisms;
import org.apache.qpid.amqp_1_0.type.security.SaslOutcome;
import org.apache.qpid.amqp_1_0.type.security.SaslResponse;
import org.apache.qpid.amqp_1_0.type.transport.Attach;
import org.apache.qpid.amqp_1_0.type.transport.Begin;
import org.apache.qpid.amqp_1_0.type.transport.Close;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Disposition;
import org.apache.qpid.amqp_1_0.type.transport.End;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.Flow;
import org.apache.qpid.amqp_1_0.type.transport.Open;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionEndpoint
implements DescribedTypeConstructorRegistry.Source,
ValueWriter.Registry.Source,
ErrorHandler,
SASLEndpoint {
    private static final short CONNECTION_CONTROL_CHANNEL = 0;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final Symbol SASL_PLAIN = Symbol.valueOf("PLAIN");
    private static final Symbol SASL_ANONYMOUS = Symbol.valueOf("ANONYMOUS");
    private static final Symbol SASL_EXTERNAL = Symbol.valueOf("EXTERNAL");
    private final Container _container;
    private Principal _user;
    private static final short DEFAULT_CHANNEL_MAX = 255;
    private static final int DEFAULT_MAX_FRAME = Integer.getInteger("amqp.max_frame_size", 32768);
    private ConnectionState _state = ConnectionState.UNOPENED;
    private short _channelMax;
    private int _maxFrameSize = 4096;
    private String _remoteContainerId;
    private SocketAddress _remoteAddress;
    private SessionEndpoint[] _sendingSessions = new SessionEndpoint[256];
    private SessionEndpoint[] _receivingSessions = new SessionEndpoint[256];
    private boolean _closedForInput;
    private boolean _closedForOutput;
    private long _idleTimeout;
    private AMQPDescribedTypeRegistry _describedTypeRegistry = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();
    private FrameOutputHandler<FrameBody> _frameOutputHandler;
    private byte _majorVersion;
    private byte _minorVersion;
    private byte _revision;
    private UnsignedInteger _handleMax = UnsignedInteger.MAX_VALUE;
    private ConnectionEventListener _connectionEventListener = ConnectionEventListener.DEFAULT;
    private String _password;
    private final boolean _requiresSASLClient;
    private final boolean _requiresSASLServer;
    private FrameOutputHandler<SaslFrameBody> _saslFrameOutput;
    private boolean _saslComplete;
    private UnsignedInteger _desiredMaxFrameSize = UnsignedInteger.valueOf(DEFAULT_MAX_FRAME);
    private Runnable _onSaslCompleteTask;
    private SaslServerProvider _saslServerProvider;
    private SaslServer _saslServer;
    private boolean _authenticated;
    private String _remoteHostname;
    private Error _remoteError;
    private Map _properties;
    private final Logger _logger = Logger.getLogger("FRM");

    public ConnectionEndpoint(Container container, SaslServerProvider cbs) {
        this._container = container;
        this._saslServerProvider = cbs;
        this._requiresSASLClient = false;
        this._requiresSASLServer = cbs != null;
    }

    public ConnectionEndpoint(Container container, Principal user, String password) {
        this._container = container;
        this._user = user;
        this._password = password;
        this._requiresSASLClient = user != null;
        this._requiresSASLServer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        if (this._requiresSASLClient) {
            Object object = this.getLock();
            synchronized (object) {
                while (!this._saslComplete) {
                    try {
                        this.getLock().wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!this._authenticated) {
                throw new RuntimeException("Could not connect - authentication error");
            }
        }
        if (this._state == ConnectionState.UNOPENED) {
            this.sendOpen((short)255, DEFAULT_MAX_FRAME);
            this._state = ConnectionState.AWAITING_OPEN;
        }
    }

    public void setFrameOutputHandler(FrameOutputHandler<FrameBody> frameOutputHandler) {
        this._frameOutputHandler = frameOutputHandler;
    }

    public void setProperties(Map<Symbol, Object> properties) {
        this._properties = properties;
    }

    public synchronized SessionEndpoint createSession(String name) {
        SessionEndpoint endpoint = new SessionEndpoint(this);
        short channel = this.getFirstFreeChannel();
        if (channel != -1) {
            this._sendingSessions[channel] = endpoint;
            endpoint.setSendingChannel(channel);
            Begin begin = new Begin();
            begin.setNextOutgoingId(endpoint.getNextOutgoingId());
            begin.setOutgoingWindow(endpoint.getOutgoingWindowSize());
            begin.setIncomingWindow(endpoint.getIncomingWindowSize());
            begin.setHandleMax(this._handleMax);
            this.send(channel, begin);
        }
        return endpoint;
    }

    public Container getContainer() {
        return this._container;
    }

    public Principal getUser() {
        return this._user;
    }

    public short getChannelMax() {
        return this._channelMax;
    }

    public int getMaxFrameSize() {
        return this._maxFrameSize;
    }

    public String getRemoteContainerId() {
        return this._remoteContainerId;
    }

    private void sendOpen(short channelMax, int maxFrameSize) {
        Open open = new Open();
        open.setChannelMax(UnsignedShort.valueOf((short)255));
        open.setContainerId(this._container.getId());
        open.setMaxFrameSize(this.getDesiredMaxFrameSize());
        open.setHostname(this.getRemoteHostname());
        if (this._properties != null) {
            open.setProperties(this._properties);
        }
        this.send((short)0, open);
    }

    public UnsignedInteger getDesiredMaxFrameSize() {
        return this._desiredMaxFrameSize;
    }

    public void setDesiredMaxFrameSize(UnsignedInteger size) {
        this._desiredMaxFrameSize = size;
    }

    private void closeSender() {
        this.setClosedForOutput(true);
        this._frameOutputHandler.close();
    }

    short getFirstFreeChannel() {
        for (int i = 0; i < this._sendingSessions.length; ++i) {
            if (this._sendingSessions[i] != null) continue;
            return (short)i;
        }
        return -1;
    }

    private SessionEndpoint getSession(short channel) {
        return this._receivingSessions[channel];
    }

    public synchronized void receiveOpen(short channel, Open open) {
        this._channelMax = (short)(open.getChannelMax() == null ? 255 : (open.getChannelMax().shortValue() < 255 ? 255 : (int)open.getChannelMax().shortValue()));
        UnsignedInteger remoteDesiredMaxFrameSize = open.getMaxFrameSize() == null ? UnsignedInteger.valueOf(DEFAULT_MAX_FRAME) : open.getMaxFrameSize();
        this._maxFrameSize = (remoteDesiredMaxFrameSize.compareTo(this._desiredMaxFrameSize) < 0 ? remoteDesiredMaxFrameSize : this._desiredMaxFrameSize).intValue();
        this._remoteContainerId = open.getContainerId();
        if (open.getIdleTimeOut() != null) {
            this._idleTimeout = open.getIdleTimeOut().longValue();
        }
        switch (this._state) {
            case UNOPENED: {
                this.sendOpen(this._channelMax, this._maxFrameSize);
            }
            case AWAITING_OPEN: {
                this._state = ConnectionState.OPEN;
            }
        }
        this.notifyAll();
    }

    public synchronized void receiveClose(short channel, Close close) {
        this.setClosedForInput(true);
        this._connectionEventListener.closeReceived();
        switch (this._state) {
            case UNOPENED: 
            case AWAITING_OPEN: {
                Error error = new Error();
                error.setCondition(ConnectionError.CONNECTION_FORCED);
                error.setDescription("Connection close sent before connection was opened");
                this.connectionError(error);
                break;
            }
            case OPEN: {
                this._state = ConnectionState.CLOSE_RECEIVED;
                this.sendClose(new Close());
                this._state = ConnectionState.CLOSED;
                break;
            }
            case CLOSE_SENT: {
                this._state = ConnectionState.CLOSED;
            }
        }
        this._remoteError = close.getError();
        this.notifyAll();
    }

    protected synchronized void connectionError(Error error) {
        Close close = new Close();
        close.setError(error);
        switch (this._state) {
            case UNOPENED: {
                this._state = ConnectionState.CLOSED;
                break;
            }
            case AWAITING_OPEN: 
            case OPEN: {
                this.sendClose(close);
                this._state = ConnectionState.CLOSE_SENT;
            }
            case CLOSE_SENT: 
            case CLOSED: {
                break;
            }
        }
    }

    public synchronized void inputClosed() {
        if (!this._closedForInput) {
            this._closedForInput = true;
            for (int i = 0; i < this._receivingSessions.length; ++i) {
                if (this._receivingSessions[i] == null) continue;
                this._receivingSessions[i].end();
                this._receivingSessions[i] = null;
            }
        }
        this.notifyAll();
    }

    private void sendClose(Close closeToSend) {
        this.send((short)0, closeToSend);
        this.closeSender();
    }

    private synchronized void setClosedForInput(boolean closed) {
        this._closedForInput = closed;
        this.notifyAll();
    }

    public synchronized void receiveBegin(short channel, Begin begin) {
        if (begin.getRemoteChannel() != null) {
            SessionEndpoint endpoint;
            short myChannelId = begin.getRemoteChannel().shortValue();
            try {
                endpoint = this._sendingSessions[myChannelId];
            }
            catch (IndexOutOfBoundsException e) {
                Error error = new Error();
                error.setCondition(ConnectionError.FRAMING_ERROR);
                error.setDescription("BEGIN received on channel " + channel + " with given remote-channel " + begin.getRemoteChannel() + " which is outside the valid range of 0 to " + this._channelMax + ".");
                this.connectionError(error);
                return;
            }
            if (endpoint != null) {
                if (this._receivingSessions[channel] == null) {
                    this._receivingSessions[channel] = endpoint;
                    endpoint.setReceivingChannel(channel);
                    endpoint.setNextIncomingId(begin.getNextOutgoingId());
                    endpoint.setOutgoingSessionCredit(begin.getIncomingWindow());
                } else {
                    Error error = new Error();
                    error.setCondition(ConnectionError.FRAMING_ERROR);
                    error.setDescription("BEGIN received on channel " + channel + " which is already in use.");
                    this.connectionError(error);
                }
            } else {
                Error error = new Error();
                error.setCondition(ConnectionError.FRAMING_ERROR);
                error.setDescription("BEGIN received on channel " + channel + " with given remote-channel " + begin.getRemoteChannel() + " which is not known as a begun session.");
                this.connectionError(error);
            }
        } else {
            short myChannelId = this.getFirstFreeChannel();
            if (myChannelId == -1) {
                myChannelId = this.getFirstFreeChannel();
            }
            if (this._receivingSessions[channel] == null) {
                SessionEndpoint endpoint;
                this._receivingSessions[channel] = endpoint = new SessionEndpoint(this, begin);
                this._sendingSessions[myChannelId] = endpoint;
                Begin beginToSend = new Begin();
                endpoint.setReceivingChannel(channel);
                endpoint.setSendingChannel(myChannelId);
                beginToSend.setRemoteChannel(UnsignedShort.valueOf(channel));
                beginToSend.setNextOutgoingId(endpoint.getNextOutgoingId());
                beginToSend.setOutgoingWindow(endpoint.getOutgoingWindowSize());
                beginToSend.setIncomingWindow(endpoint.getIncomingWindowSize());
                this.send(myChannelId, beginToSend);
                this._connectionEventListener.remoteSessionCreation(endpoint);
            } else {
                Error error = new Error();
                error.setCondition(ConnectionError.FRAMING_ERROR);
                error.setDescription("BEGIN received on channel " + channel + " which is already in use.");
                this.connectionError(error);
            }
        }
    }

    public synchronized void receiveEnd(short channel, End end) {
        SessionEndpoint endpoint = this._receivingSessions[channel];
        if (endpoint != null) {
            this._receivingSessions[channel] = null;
            endpoint.end(end);
        }
    }

    public synchronized void sendEnd(short channel, End end) {
        this.send(channel, end);
        this._sendingSessions[channel] = null;
    }

    public synchronized void receiveAttach(short channel, Attach attach) {
        SessionEndpoint endPoint = this.getSession(channel);
        endPoint.receiveAttach(attach);
    }

    public synchronized void receiveDetach(short channel, Detach detach) {
        SessionEndpoint endPoint = this.getSession(channel);
        endPoint.receiveDetach(detach);
    }

    public synchronized void receiveTransfer(short channel, Transfer transfer) {
        SessionEndpoint endPoint = this.getSession(channel);
        endPoint.receiveTransfer(transfer);
    }

    public synchronized void receiveDisposition(short channel, Disposition disposition) {
        SessionEndpoint endPoint = this.getSession(channel);
        endPoint.receiveDisposition(disposition);
    }

    public synchronized void receiveFlow(short channel, Flow flow) {
        SessionEndpoint endPoint = this.getSession(channel);
        endPoint.receiveFlow(flow);
    }

    public synchronized void send(short channel, FrameBody body) {
        this.send(channel, body, null);
    }

    public synchronized int send(short channel, FrameBody body, ByteBuffer payload) {
        if (!this._closedForOutput) {
            ValueWriter<FrameBody> writer = this._describedTypeRegistry.getValueWriter(body);
            int size = writer.writeToBuffer(EMPTY_BYTE_BUFFER);
            ByteBuffer payloadDup = payload == null ? null : payload.duplicate();
            int payloadSent = this.getMaxFrameSize() - (size + 9);
            if (payloadSent < (payload == null ? 0 : payload.remaining())) {
                if (body instanceof Transfer) {
                    ((Transfer)body).setMore(Boolean.TRUE);
                }
                writer = this._describedTypeRegistry.getValueWriter(body);
                size = writer.writeToBuffer(EMPTY_BYTE_BUFFER);
                payloadSent = this.getMaxFrameSize() - (size + 9);
                payloadDup.limit(payloadDup.position() + payloadSent);
            } else {
                payloadSent = payload == null ? 0 : payload.remaining();
            }
            this._frameOutputHandler.send(AMQFrame.createAMQFrame(channel, body, payloadDup));
            return payloadSent;
        }
        return -1;
    }

    public void invalidHeaderReceived() {
        this._closedForInput = true;
    }

    public synchronized boolean closedForInput() {
        return this._closedForInput;
    }

    public synchronized void protocolHeaderReceived(byte major, byte minorVersion, byte revision) {
        if (!this._requiresSASLServer || this._state != ConnectionState.UNOPENED) {
            // empty if block
        }
        this._majorVersion = major;
        this._minorVersion = minorVersion;
        this._revision = revision;
    }

    @Override
    public synchronized void handleError(Error error) {
        if (!this.closedForOutput()) {
            Close close = new Close();
            close.setError(error);
            this.send((short)0, close);
        }
        this._closedForInput = true;
    }

    public synchronized void receive(short channel, Object frame) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("RECV[" + this._remoteAddress + "|" + channel + "] : " + frame);
        }
        if (frame instanceof FrameBody) {
            ((FrameBody)frame).invoke(channel, this);
        } else if (frame instanceof SaslFrameBody) {
            ((SaslFrameBody)frame).invoke(this);
        }
    }

    @Override
    public AMQPDescribedTypeRegistry getDescribedTypeRegistry() {
        return this._describedTypeRegistry;
    }

    public synchronized void setClosedForOutput(boolean b) {
        this._closedForOutput = true;
        this.notifyAll();
    }

    public synchronized boolean closedForOutput() {
        return this._closedForOutput;
    }

    public Object getLock() {
        return this;
    }

    public synchronized long getIdleTimeout() {
        return this._idleTimeout;
    }

    public synchronized void close() {
        switch (this._state) {
            case AWAITING_OPEN: 
            case OPEN: {
                Close closeToSend = new Close();
                this.sendClose(closeToSend);
                this._state = ConnectionState.CLOSE_SENT;
                break;
            }
        }
    }

    public void setConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this._connectionEventListener = connectionEventListener;
    }

    public ConnectionEventListener getConnectionEventListener() {
        return this._connectionEventListener;
    }

    public byte getMinorVersion() {
        return this._minorVersion;
    }

    public byte getRevision() {
        return this._revision;
    }

    public byte getMajorVersion() {
        return this._majorVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSaslInit(SaslInit saslInit) {
        block10: {
            Symbol mechanism = saslInit.getMechanism();
            Binary initialResponse = saslInit.getInitialResponse();
            byte[] response = initialResponse == null ? new byte[]{} : initialResponse.getArray();
            try {
                this._saslServer = this._saslServerProvider.getSaslServer(mechanism.toString(), "localhost");
                byte[] challenge = this._saslServer.evaluateResponse(response != null ? response : new byte[]{});
                if (this._saslServer.isComplete()) {
                    SaslOutcome outcome = new SaslOutcome();
                    outcome.setCode(SaslCode.OK);
                    this._saslFrameOutput.send(new SASLFrame(outcome), null);
                    Object object = this.getLock();
                    synchronized (object) {
                        this._saslComplete = true;
                        this._authenticated = true;
                        this._user = this._saslServerProvider.getAuthenticatedPrincipal(this._saslServer);
                        this.getLock().notifyAll();
                    }
                    if (this._onSaslCompleteTask != null) {
                        this._onSaslCompleteTask.run();
                    }
                    break block10;
                }
                SaslChallenge challengeBody = new SaslChallenge();
                challengeBody.setChallenge(new Binary(challenge));
                this._saslFrameOutput.send(new SASLFrame(challengeBody), null);
            }
            catch (SaslException e) {
                SaslOutcome outcome = new SaslOutcome();
                outcome.setCode(SaslCode.AUTH);
                this._saslFrameOutput.send(new SASLFrame(outcome), null);
                Object object = this.getLock();
                synchronized (object) {
                    this._saslComplete = true;
                    this._authenticated = false;
                    this.getLock().notifyAll();
                }
                if (this._onSaslCompleteTask == null) break block10;
                this._onSaslCompleteTask.run();
            }
        }
    }

    @Override
    public void receiveSaslMechanisms(SaslMechanisms saslMechanisms) {
        SaslInit init = new SaslInit();
        init.setHostname(this._remoteHostname);
        HashSet<Symbol> mechanisms = new HashSet<Symbol>(Arrays.asList(saslMechanisms.getSaslServerMechanisms()));
        if (mechanisms.contains(SASL_PLAIN) && this._password != null) {
            init.setMechanism(SASL_PLAIN);
            byte[] usernameBytes = this._user.getName().getBytes(Charset.forName("UTF-8"));
            byte[] passwordBytes = this._password.getBytes(Charset.forName("UTF-8"));
            byte[] initResponse = new byte[usernameBytes.length + passwordBytes.length + 2];
            System.arraycopy(usernameBytes, 0, initResponse, 1, usernameBytes.length);
            System.arraycopy(passwordBytes, 0, initResponse, usernameBytes.length + 2, passwordBytes.length);
            init.setInitialResponse(new Binary(initResponse));
        } else if (mechanisms.contains(SASL_ANONYMOUS)) {
            init.setMechanism(SASL_ANONYMOUS);
        } else if (mechanisms.contains(SASL_EXTERNAL)) {
            init.setMechanism(SASL_EXTERNAL);
        }
        this._saslFrameOutput.send(new SASLFrame(init), null);
    }

    @Override
    public void receiveSaslChallenge(SaslChallenge saslChallenge) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSaslResponse(SaslResponse saslResponse) {
        block10: {
            Binary responseBinary = saslResponse.getResponse();
            byte[] response = responseBinary == null ? new byte[]{} : responseBinary.getArray();
            try {
                byte[] challenge = this._saslServer.evaluateResponse(response != null ? response : new byte[]{});
                if (this._saslServer.isComplete()) {
                    SaslOutcome outcome = new SaslOutcome();
                    outcome.setCode(SaslCode.OK);
                    this._saslFrameOutput.send(new SASLFrame(outcome), null);
                    Object object = this.getLock();
                    synchronized (object) {
                        this._saslComplete = true;
                        this._authenticated = true;
                        this._user = this._saslServerProvider.getAuthenticatedPrincipal(this._saslServer);
                        this.getLock().notifyAll();
                    }
                    if (this._onSaslCompleteTask != null) {
                        this._onSaslCompleteTask.run();
                    }
                    break block10;
                }
                SaslChallenge challengeBody = new SaslChallenge();
                challengeBody.setChallenge(new Binary(challenge));
                this._saslFrameOutput.send(new SASLFrame(challengeBody), null);
            }
            catch (SaslException e) {
                SaslOutcome outcome = new SaslOutcome();
                outcome.setCode(SaslCode.AUTH);
                this._saslFrameOutput.send(new SASLFrame(outcome), null);
                Object object = this.getLock();
                synchronized (object) {
                    this._saslComplete = true;
                    this._authenticated = false;
                    this.getLock().notifyAll();
                }
                if (this._onSaslCompleteTask == null) break block10;
                this._onSaslCompleteTask.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSaslOutcome(SaslOutcome saslOutcome) {
        if (saslOutcome.getCode() == SaslCode.OK) {
            this._saslFrameOutput.close();
            Object object = this.getLock();
            synchronized (object) {
                this._saslComplete = true;
                this._authenticated = true;
                this.getLock().notifyAll();
            }
            if (this._onSaslCompleteTask != null) {
                this._onSaslCompleteTask.run();
            }
        } else {
            Object object = this.getLock();
            synchronized (object) {
                this._saslComplete = true;
                this._authenticated = false;
                this.getLock().notifyAll();
            }
            this.setClosedForInput(true);
            this._saslFrameOutput.close();
        }
    }

    public boolean requiresSASL() {
        return this._requiresSASLClient || this._requiresSASLServer;
    }

    public void setSaslFrameOutput(FrameOutputHandler<SaslFrameBody> saslFrameOutput) {
        this._saslFrameOutput = saslFrameOutput;
    }

    public void setOnSaslComplete(Runnable task) {
        this._onSaslCompleteTask = task;
    }

    public boolean isAuthenticated() {
        return this._authenticated;
    }

    public void initiateSASL(String[] mechanismNames) {
        SaslMechanisms mechanisms = new SaslMechanisms();
        ArrayList<Symbol> mechanismsList = new ArrayList<Symbol>();
        for (String name : mechanismNames) {
            mechanismsList.add(Symbol.valueOf(name));
        }
        mechanisms.setSaslServerMechanisms(mechanismsList.toArray(new Symbol[mechanismsList.size()]));
        this._saslFrameOutput.send(new SASLFrame(mechanisms), null);
    }

    public boolean isSASLComplete() {
        return this._saslComplete;
    }

    public SocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this._remoteAddress = remoteAddress;
    }

    public String getRemoteHostname() {
        return this._remoteHostname;
    }

    public void setRemoteHostname(String remoteHostname) {
        this._remoteHostname = remoteHostname;
    }

    public boolean isOpen() {
        return this._state == ConnectionState.OPEN;
    }

    public boolean isClosed() {
        return this._state == ConnectionState.CLOSED || this._state == ConnectionState.CLOSE_RECEIVED || this._state == ConnectionState.CLOSE_RECEIVED;
    }

    public Error getRemoteError() {
        return this._remoteError;
    }
}

