/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.transport;

import java.io.PrintWriter;
import java.util.Arrays;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.amqp_1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.transport.ConnectionEventListener;
import org.apache.qpid.amqp_1_0.transport.FrameOutputHandler;
import org.apache.qpid.amqp_1_0.transport.FrameTransport;
import org.apache.qpid.amqp_1_0.transport.SASLEndpoint;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.SaslFrameBody;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.amqp_1_0.type.security.SaslChallenge;
import org.apache.qpid.amqp_1_0.type.security.SaslInit;
import org.apache.qpid.amqp_1_0.type.security.SaslMechanisms;
import org.apache.qpid.amqp_1_0.type.security.SaslOutcome;
import org.apache.qpid.amqp_1_0.type.security.SaslResponse;

public class SASLEndpointImpl
implements DescribedTypeConstructorRegistry.Source,
ValueWriter.Registry.Source,
SASLEndpoint {
    private static final short SASL_CONTROL_CHANNEL = 0;
    private static final byte[] EMPTY_CHALLENGE = new byte[0];
    private FrameTransport _transport;
    public PrintWriter _out;
    private State _state;
    private SaslClient _saslClient;
    private SaslServer _saslServer;
    private boolean _isReadable;
    private boolean _isWritable;
    private boolean _closedForInput;
    private boolean _closedForOutput;
    private AMQPDescribedTypeRegistry _describedTypeRegistry = AMQPDescribedTypeRegistry.newInstance().registerSecurityLayer();
    private FrameOutputHandler _frameOutputHandler;
    private byte _majorVersion;
    private byte _minorVersion;
    private byte _revision;
    private UnsignedInteger _handleMax = UnsignedInteger.MAX_VALUE;
    private ConnectionEventListener _connectionEventListener = ConnectionEventListener.DEFAULT;
    private Symbol[] _mechanisms;
    private Symbol _mechanism;

    private SASLEndpointImpl(FrameTransport transport, State initialState, Symbol ... mechanisms) {
        this._transport = transport;
        this._state = initialState;
        this._mechanisms = mechanisms;
    }

    public void setFrameOutputHandler(FrameOutputHandler frameOutputHandler) {
        this._frameOutputHandler = frameOutputHandler;
        if (this._state == State.BEGIN_SERVER) {
            this.sendMechanisms();
        }
    }

    private synchronized void sendMechanisms() {
        SaslMechanisms saslMechanisms = new SaslMechanisms();
        saslMechanisms.setSaslServerMechanisms(this._mechanisms);
        this._state = State.SENT_MECHANISMS;
        this.send(saslMechanisms);
    }

    public boolean isReadable() {
        return this._isReadable;
    }

    public boolean isWritable() {
        return this._isWritable;
    }

    public synchronized void send(SaslFrameBody body) {
        if (!this._closedForOutput && this._out != null) {
            this._out.println("SEND : " + body);
            this._out.flush();
        }
    }

    public void invalidHeaderReceived() {
        this._closedForInput = true;
    }

    public synchronized boolean closedForInput() {
        return this._closedForInput;
    }

    public synchronized void protocolHeaderReceived(byte major, byte minorVersion, byte revision) {
        this._majorVersion = major;
        this._minorVersion = minorVersion;
        this._revision = revision;
    }

    public synchronized void receive(short channel, Object frame) {
        if (this._out != null) {
            this._out.println("RECV[" + channel + "] : " + frame);
            this._out.flush();
        }
        if (frame instanceof SaslFrameBody) {
            ((SaslFrameBody)frame).invoke(this);
        }
    }

    public AMQPDescribedTypeRegistry getDescribedTypeRegistry() {
        return this._describedTypeRegistry;
    }

    public synchronized void setClosedForOutput(boolean b) {
        this._closedForOutput = true;
        this.notifyAll();
    }

    public synchronized boolean closedForOutput() {
        return this._closedForOutput;
    }

    public Object getLock() {
        return this;
    }

    public byte getMajorVersion() {
        return this._majorVersion;
    }

    public byte getMinorVersion() {
        return this._minorVersion;
    }

    public byte getRevision() {
        return this._revision;
    }

    public void receiveSaslInit(SaslInit saslInit) {
        this._mechanism = saslInit.getMechanism();
        try {
            this._saslServer = Sasl.createSaslServer(this._mechanism.toString(), "AMQP", "localhost", null, this.createServerCallbackHandler(this._mechanism));
        }
        catch (SaslException e) {
            e.printStackTrace();
        }
    }

    private CallbackHandler createServerCallbackHandler(Symbol mechanism) {
        return null;
    }

    public synchronized void receiveSaslMechanisms(SaslMechanisms saslMechanisms) {
        Symbol[] serverMechanisms = saslMechanisms.getSaslServerMechanisms();
        for (Symbol mechanism : this._mechanisms) {
            if (!Arrays.asList(serverMechanisms).contains(mechanism)) continue;
            this._mechanism = mechanism;
            break;
        }
        try {
            this._saslClient = Sasl.createSaslClient(new String[]{this._mechanism.toString()}, null, "AMQP", "localhost", null, this.createClientCallbackHandler(this._mechanism));
            SaslInit init = new SaslInit();
            init.setMechanism(this._mechanism);
            init.setInitialResponse(this._saslClient.hasInitialResponse() ? new Binary(this._saslClient.evaluateChallenge(EMPTY_CHALLENGE)) : null);
            this.send(init);
        }
        catch (SaslException e) {
            e.printStackTrace();
        }
    }

    private CallbackHandler createClientCallbackHandler(Symbol mechanism) {
        return null;
    }

    public void receiveSaslChallenge(SaslChallenge saslChallenge) {
    }

    public void receiveSaslResponse(SaslResponse saslResponse) {
    }

    public void receiveSaslOutcome(SaslOutcome saslOutcome) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        BEGIN_SERVER,
        BEGIN_CLIENT,
        SENT_MECHANISMS,
        SENT_INIT,
        SENT_REPSONSE,
        SENT_CHALLENGE,
        SENT_OUTCOME;

    }
}

