/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnsignedInteger
extends Number
implements Comparable<UnsignedInteger> {
    private final int _underlying;
    private static final UnsignedInteger[] cachedValues = new UnsignedInteger[256];
    public static final UnsignedInteger ZERO;
    public static final UnsignedInteger ONE;
    public static final UnsignedInteger MAX_VALUE;

    public UnsignedInteger(int underlying) {
        this._underlying = underlying;
    }

    @Override
    public int intValue() {
        return this._underlying;
    }

    @Override
    public long longValue() {
        return (long)this._underlying & 0xFFFFFFFFL;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedInteger that = (UnsignedInteger)o;
        return this._underlying == that._underlying;
    }

    @Override
    public int compareTo(UnsignedInteger o) {
        return Long.signum(this.longValue() - o.longValue());
    }

    public int hashCode() {
        return this._underlying;
    }

    public String toString() {
        return String.valueOf(this.longValue());
    }

    public static UnsignedInteger valueOf(int underlying) {
        if ((underlying & 0xFFFFFF00) == 0) {
            return cachedValues[underlying];
        }
        return new UnsignedInteger(underlying);
    }

    public UnsignedInteger add(UnsignedInteger i) {
        int val = this._underlying + i._underlying;
        return UnsignedInteger.valueOf(val);
    }

    public UnsignedInteger subtract(UnsignedInteger i) {
        int val = this._underlying - i._underlying;
        return UnsignedInteger.valueOf(val);
    }

    public static UnsignedInteger valueOf(String value) {
        long longVal = Long.parseLong(value);
        return UnsignedInteger.valueOf(longVal);
    }

    public static UnsignedInteger valueOf(long longVal) {
        if (longVal < 0L || longVal >= 0x100000000L) {
            throw new NumberFormatException("Value \"" + longVal + "\" lies outside the range [" + 0L + "-" + 0x100000000L + ").");
        }
        return UnsignedInteger.valueOf((int)longVal);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            UnsignedInteger.cachedValues[i] = new UnsignedInteger(i);
        }
        ZERO = cachedValues[0];
        ONE = cachedValues[1];
        MAX_VALUE = new UnsignedInteger(-1);
    }
}

