/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import org.apache.qpid.amqp_1_0.client.ConnectionClosedException;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.Session;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.framing.ConnectionHandler;
import org.apache.qpid.amqp_1_0.transport.AMQPTransport;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.transport.Container;
import org.apache.qpid.amqp_1_0.transport.FrameOutputHandler;
import org.apache.qpid.amqp_1_0.transport.StateChangeListener;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;

public class Connection {
    private static final Logger RAW_LOGGER = Logger.getLogger("RAW");
    private static final int MAX_FRAME_SIZE = 65536;
    private String _address;
    private ConnectionEndpoint _conn;
    private int _sessionCount;

    public Connection(String address, int port, String username, String password) throws ConnectionException {
        this(address, port, username, password, 65536);
    }

    public Connection(String address, int port, String username, String password, String remoteHostname) throws ConnectionException {
        this(address, port, username, password, 65536, new Container(), remoteHostname);
    }

    public Connection(String address, int port, String username, String password, int maxFrameSize) throws ConnectionException {
        this(address, port, username, password, maxFrameSize, new Container());
    }

    public Connection(String address, int port, String username, String password, Container container) throws ConnectionException {
        this(address, port, username, password, 65536, container);
    }

    public Connection(String address, int port, String username, String password, int maxFrameSize, Container container) throws ConnectionException {
        this(address, port, username, password, maxFrameSize, container, null);
    }

    public Connection(String address, int port, String username, String password, int maxFrameSize, Container container, String remoteHostname) throws ConnectionException {
        this(address, port, username, password, maxFrameSize, container, remoteHostname, false);
    }

    public Connection(String address, int port, String username, String password, Container container, boolean ssl) throws ConnectionException {
        this(address, port, username, password, 65536, container, null, ssl);
    }

    public Connection(String address, int port, String username, String password, String remoteHost, boolean ssl) throws ConnectionException {
        this(address, port, username, password, 65536, new Container(), remoteHost, ssl);
    }

    public Connection(String address, int port, String username, String password, Container container, String remoteHost, boolean ssl) throws ConnectionException {
        this(address, port, username, password, 65536, container, remoteHost, ssl);
    }

    public Connection(String address, int port, final String username, String password, int maxFrameSize, Container container, String remoteHostname, boolean ssl) throws ConnectionException {
        this._address = address;
        try {
            ConnectionHandler.SequentialBytesSource src;
            final Socket s = ssl ? SSLSocketFactory.getDefault().createSocket(address, port) : new Socket(address, port);
            Principal principal = username == null ? null : new Principal(){

                public String getName() {
                    return username;
                }
            };
            this._conn = new ConnectionEndpoint(container, principal, password);
            this._conn.setDesiredMaxFrameSize(UnsignedInteger.valueOf((int)maxFrameSize));
            this._conn.setRemoteAddress(s.getRemoteSocketAddress());
            this._conn.setRemoteHostname(remoteHostname);
            ConnectionHandler.FrameOutput out = new ConnectionHandler.FrameOutput(this._conn);
            OutputStream outputStream = s.getOutputStream();
            if (this._conn.requiresSASL()) {
                ConnectionHandler.FrameOutput saslOut = new ConnectionHandler.FrameOutput(this._conn);
                src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.BytesSource[]{new ConnectionHandler.HeaderBytesSource(this._conn, new byte[]{65, 77, 81, 80, 3, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter((ConnectionHandler.FrameSource)saslOut, (ValueWriter.Registry)this._conn.getDescribedTypeRegistry()), new ConnectionHandler.HeaderBytesSource(this._conn, new byte[]{65, 77, 81, 80, 0, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter((ConnectionHandler.FrameSource)out, (ValueWriter.Registry)this._conn.getDescribedTypeRegistry())});
                this._conn.setSaslFrameOutput((FrameOutputHandler)saslOut);
            } else {
                src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.BytesSource[]{new ConnectionHandler.HeaderBytesSource(this._conn, new byte[]{65, 77, 81, 80, 0, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter((ConnectionHandler.FrameSource)out, (ValueWriter.Registry)this._conn.getDescribedTypeRegistry())});
            }
            ConnectionHandler.BytesOutputHandler outputHandler = new ConnectionHandler.BytesOutputHandler(outputStream, (ConnectionHandler.BytesSource)src, this._conn);
            Thread outputThread = new Thread((Runnable)outputHandler);
            outputThread.setDaemon(true);
            outputThread.start();
            this._conn.setFrameOutputHandler((FrameOutputHandler)out);
            final ConnectionHandler handler = new ConnectionHandler(this._conn);
            final InputStream inputStream = s.getInputStream();
            Thread inputThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Connection.this.doRead(handler, inputStream);
                    }
                    finally {
                        if (Connection.this._conn.closedForInput() && Connection.this._conn.closedForOutput()) {
                            try {
                                s.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            inputThread.setDaemon(true);
            inputThread.start();
            this._conn.open();
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    private Connection(ConnectionEndpoint endpoint) {
        this._conn = endpoint;
    }

    private void doRead(AMQPTransport transport, InputStream inputStream) {
        byte[] buf = new byte[65536];
        ByteBuffer bbuf = ByteBuffer.wrap(buf);
        final Object lock = new Object();
        transport.setInputStateChangeListener(new StateChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStateChange(boolean active) {
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        });
        try {
            int read;
            while ((read = inputStream.read(buf)) != -1) {
                bbuf.position(0);
                bbuf.limit(read);
                while (bbuf.hasRemaining() && transport.isOpenForInput()) {
                    transport.processBytes(bbuf);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Session createSession() throws ConnectionException {
        this.checkNotClosed();
        Session session = new Session(this, String.valueOf(this._sessionCount++));
        return session;
    }

    void checkNotClosed() throws ConnectionClosedException {
        if (this.getEndpoint().isClosed()) {
            throw new ConnectionClosedException(this.getEndpoint().getRemoteError());
        }
    }

    public ConnectionEndpoint getEndpoint() {
        return this._conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitOpen() {
        Object object = this.getEndpoint().getLock();
        synchronized (object) {
            while (!this.getEndpoint().isOpen() && !this.getEndpoint().isClosed()) {
                try {
                    this.getEndpoint().getLock().wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void doRead(ConnectionHandler handler, InputStream inputStream) {
        byte[] buf = new byte[65536];
        try {
            int read;
            boolean done = false;
            while (!handler.isDone() && (read = inputStream.read(buf)) != -1) {
                ByteBuffer bbuf = ByteBuffer.wrap(buf, 0, read);
                Binary b = new Binary(buf, 0, read);
                if (RAW_LOGGER.isLoggable(Level.FINE)) {
                    RAW_LOGGER.fine("RECV [" + this._conn.getRemoteAddress() + "] : " + b.toString());
                }
                while (bbuf.hasRemaining() && !handler.isDone()) {
                    handler.parse(bbuf);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this._conn.close();
        Object object = this._conn.getLock();
        synchronized (object) {
            while (!this._conn.closedForInput()) {
                try {
                    this._conn.getLock().wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

