/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.qpid.amqp_1_0.client.Receiver;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private Binary _deliveryTag;
    private List<Section> _payload = new ArrayList<Section>();
    private Boolean _resume;
    private boolean _settled;
    private DeliveryState _deliveryState;
    private Receiver _receiver;

    public Message() {
    }

    public Message(Collection<Section> sections) {
        this._payload.addAll(sections);
    }

    public Message(Section section) {
        this(Collections.singletonList(section));
    }

    public Message(String message) {
        this((Section)new AmqpValue((Object)message));
    }

    public Binary getDeliveryTag() {
        return this._deliveryTag;
    }

    public void setDeliveryTag(Binary deliveryTag) {
        this._deliveryTag = deliveryTag;
    }

    public List<Section> getPayload() {
        return Collections.unmodifiableList(this._payload);
    }

    private <T extends Section> T getSection(Class<T> clazz) {
        for (Section s : this._payload) {
            if (!clazz.isAssignableFrom(s.getClass())) continue;
            return (T)s;
        }
        return null;
    }

    public ApplicationProperties getApplicationProperties() {
        return this.getSection(ApplicationProperties.class);
    }

    public Properties getProperties() {
        return this.getSection(Properties.class);
    }

    public Header getHeader() {
        return this.getSection(Header.class);
    }

    public void setResume(Boolean resume) {
        this._resume = resume;
    }

    public boolean isResume() {
        return Boolean.TRUE.equals(this._resume);
    }

    public void setDeliveryState(DeliveryState state) {
        this._deliveryState = state;
    }

    public DeliveryState getDeliveryState() {
        return this._deliveryState;
    }

    public void setSettled(boolean settled) {
        this._settled = settled;
    }

    public boolean getSettled() {
        return this._settled;
    }

    public void setReceiver(Receiver receiver) {
        this._receiver = receiver;
    }

    public Receiver getReceiver() {
        return this._receiver;
    }
}

