/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;

public class NullWriter
implements ValueWriter<Void> {
    private boolean _complete = true;
    private static ValueWriter.Factory<Void> FACTORY = new ValueWriter.Factory<Void>(){

        @Override
        public ValueWriter<Void> newInstance(ValueWriter.Registry registry) {
            return new NullWriter();
        }
    };

    @Override
    public int writeToBuffer(ByteBuffer buffer) {
        if (!this._complete && buffer.hasRemaining()) {
            buffer.put((byte)64);
            this._complete = true;
        }
        return 1;
    }

    @Override
    public void setValue(Void frameBody) {
        this._complete = false;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this._complete;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Void.TYPE, FACTORY);
    }
}

