/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ProtocolHandler;
import org.apache.qpid.amqp_1_0.framing.AMQPProtocolHeaderHandler;
import org.apache.qpid.amqp_1_0.framing.SASLProtocolHeaderHandler;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;

public class ProtocolHeaderHandler
implements ProtocolHandler {
    private final ConnectionEndpoint _connection;
    private ProtocolHandler[] _protocolHandlers = new ProtocolHandler[4];
    private boolean _done;
    private State _state = State.AWAITING_A;

    public ProtocolHeaderHandler(ConnectionEndpoint connection) {
        this._connection = connection;
        this._protocolHandlers[0] = new AMQPProtocolHeaderHandler(connection);
        this._protocolHandlers[1] = null;
        this._protocolHandlers[2] = null;
        this._protocolHandlers[3] = new SASLProtocolHeaderHandler(connection);
    }

    @Override
    public ProtocolHandler parse(ByteBuffer in) {
        if (!in.hasRemaining()) {
            return this;
        }
        switch (this._state) {
            case AWAITING_A: {
                if (this.transition(in, (byte)65, State.AWAITING_M)) break;
            }
            case AWAITING_M: {
                if (this.transition(in, (byte)77, State.AWAITING_Q)) break;
            }
            case AWAITING_Q: {
                if (this.transition(in, (byte)81, State.AWAITING_P)) break;
            }
            case AWAITING_P: {
                if (this.transition(in, (byte)80, State.AWAITING_PROTOCOL_ID)) break;
            }
            case AWAITING_PROTOCOL_ID: {
                ProtocolHandler delegate;
                int protocolId = in.get() & 0xFF;
                try {
                    delegate = this._protocolHandlers[protocolId];
                }
                catch (IndexOutOfBoundsException e) {
                    delegate = null;
                }
                if (delegate == null) {
                    this._state = State.ERROR;
                    break;
                }
                return delegate.parse(in);
            }
        }
        if (this._state == State.ERROR) {
            this._connection.invalidHeaderReceived();
            this._done = true;
        }
        return this;
    }

    boolean transition(ByteBuffer in, byte expected, State next) {
        byte b = in.get();
        if (b == expected) {
            if (!in.hasRemaining()) {
                this._state = next;
                return true;
            }
            return false;
        }
        this._state = State.ERROR;
        return true;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    static enum State {
        AWAITING_A,
        AWAITING_M,
        AWAITING_Q,
        AWAITING_P,
        AWAITING_PROTOCOL_ID,
        ERROR;

    }
}

