/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.TransportProvider;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.framing.ConnectionHandler;
import org.apache.qpid.amqp_1_0.framing.ExceptionHandler;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.transport.FrameOutputHandler;

class TCPTransportProvier
implements TransportProvider {
    private final String _transport;

    public TCPTransportProvier(String transport) {
        this._transport = transport;
    }

    @Override
    public void connect(final ConnectionEndpoint conn, String address, int port, SSLContext sslContext, ExceptionHandler exceptionHandler) throws ConnectionException {
        try {
            ConnectionHandler.SequentialBytesSource src;
            Socket s;
            if (sslContext != null) {
                SSLSocketFactory socketFactory = sslContext.getSocketFactory();
                SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket(address, port);
                s = sslSocket;
            } else {
                s = new Socket(address, port);
            }
            conn.setRemoteAddress(s.getRemoteSocketAddress());
            ConnectionHandler.FrameOutput out = new ConnectionHandler.FrameOutput(conn);
            if (conn.requiresSASL()) {
                ConnectionHandler.FrameOutput saslOut = new ConnectionHandler.FrameOutput(conn);
                src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.BytesSource[]{new ConnectionHandler.HeaderBytesSource(conn, new byte[]{65, 77, 81, 80, 3, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter((ConnectionHandler.FrameSource)saslOut, (ValueWriter.Registry)conn.getDescribedTypeRegistry()), new ConnectionHandler.HeaderBytesSource(conn, new byte[]{65, 77, 81, 80, 0, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter((ConnectionHandler.FrameSource)out, (ValueWriter.Registry)conn.getDescribedTypeRegistry())});
                conn.setSaslFrameOutput((FrameOutputHandler)saslOut);
            } else {
                src = new ConnectionHandler.SequentialBytesSource(new ConnectionHandler.BytesSource[]{new ConnectionHandler.HeaderBytesSource(conn, new byte[]{65, 77, 81, 80, 0, 1, 0, 0}), new ConnectionHandler.FrameToBytesSourceAdapter((ConnectionHandler.FrameSource)out, (ValueWriter.Registry)conn.getDescribedTypeRegistry())});
            }
            final OutputStream outputStream = s.getOutputStream();
            ConnectionHandler.BytesOutputHandler outputHandler = new ConnectionHandler.BytesOutputHandler(outputStream, (ConnectionHandler.BytesSource)src, conn, exceptionHandler);
            Thread outputThread = new Thread((Runnable)outputHandler);
            outputThread.setDaemon(true);
            outputThread.start();
            conn.setFrameOutputHandler((FrameOutputHandler)out);
            final ConnectionHandler handler = new ConnectionHandler(conn);
            final InputStream inputStream = s.getInputStream();
            Thread inputThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TCPTransportProvier.this.doRead(conn, handler, inputStream);
                    }
                    finally {
                        if (conn.closedForInput() && conn.closedForOutput()) {
                            try {
                                OutputStream outputStream2 = outputStream;
                                synchronized (outputStream2) {
                                    s.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            inputThread.setDaemon(true);
            inputThread.start();
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    private void doRead(ConnectionEndpoint conn, ConnectionHandler handler, InputStream inputStream) {
        byte[] buf = new byte[65536];
        try {
            int read;
            boolean done = false;
            while (!handler.isDone() && (read = inputStream.read(buf)) != -1) {
                ByteBuffer bbuf = ByteBuffer.wrap(buf, 0, read);
                while (bbuf.hasRemaining() && !handler.isDone()) {
                    handler.parse(bbuf);
                }
            }
            if (!handler.isDone()) {
                conn.inputClosed();
                if (conn.getConnectionEventListener() != null) {
                    conn.getConnectionEventListener().closeReceived();
                }
            }
        }
        catch (IOException e) {
            conn.inputClosed();
            e.printStackTrace();
        }
    }
}

