/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.UUID;
import java.util.WeakHashMap;
import javax.jms.JMSException;
import org.apache.qpid.amqp_1_0.jms.Destination;

public class DestinationImpl
implements Destination {
    private static final WeakHashMap<String, DestinationImpl> DESTINATION_CACHE = new WeakHashMap();
    private final String _address;
    private String _localTerminus;

    protected DestinationImpl(String address) {
        this._address = address;
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    public static DestinationImpl valueOf(String address) {
        return address == null ? null : DestinationImpl.createDestination(address);
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this._address.equals(((DestinationImpl)obj)._address);
    }

    public static synchronized DestinationImpl createDestination(String address) {
        DestinationImpl destination;
        if (address.endsWith("!!")) {
            address = address.substring(0, address.length() - 2);
            String localTerminusName = UUID.randomUUID().toString();
            destination = new DestinationImpl(address);
            destination.setLocalTerminus(localTerminusName);
        } else {
            destination = DESTINATION_CACHE.get(address);
            if (destination == null) {
                destination = new DestinationImpl(address);
                DESTINATION_CACHE.put(address, destination);
            }
        }
        return destination;
    }

    public String getQueueName() throws JMSException {
        return this.getAddress();
    }

    public String getTopicName() throws JMSException {
        return this.getAddress();
    }

    void setLocalTerminus(String localTerminus) {
        this._localTerminus = localTerminus;
    }

    String getLocalTerminus() {
        return this._localTerminus;
    }
}

