/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;

public class SSLUtil {
    public static final String TRANSPORT_LAYER_SECURITY_CODE = "TLS";

    public static SSLContext buildSslContext(String certAlias, String keyStorePath, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithm, String trustStorePath, String trustStorePassword, String trustStoreType, String trustManagerFactoryAlgorithm) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers;
        TrustManager[] trustManagers;
        SSLContext sslContext = SSLContext.getInstance(TRANSPORT_LAYER_SECURITY_CODE);
        if (trustStorePath != null) {
            KeyStore ts = SSLUtil.getInitializedKeyStore(trustStorePath, trustStorePassword, trustStoreType);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
            tmf.init(ts);
            trustManagers = tmf.getTrustManagers();
        } else {
            trustManagers = null;
        }
        if (keyStorePath != null) {
            if (certAlias != null) {
                keyManagers = new KeyManager[]{new QpidClientX509KeyManager(certAlias, keyStorePath, keyStoreType, keyStorePassword, keyManagerFactoryAlgorithm)};
            } else {
                KeyStore ks = SSLUtil.getInitializedKeyStore(keyStorePath, keyStorePassword, keyStoreType);
                char[] keyStoreCharPassword = keyStorePassword == null ? null : keyStorePassword.toCharArray();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
                kmf.init(ks, keyStoreCharPassword);
                keyManagers = kmf.getKeyManagers();
            }
        } else {
            keyManagers = null;
        }
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public static X509Certificate[] getClientCertificates(String alias, String keyStorePath, String keyStorePassword, String keyStoreType, String keyManagerFactoryAlgorithm) throws GeneralSecurityException, IOException {
        return new QpidClientX509KeyManager(alias, keyStorePath, keyStoreType, keyStorePassword, keyManagerFactoryAlgorithm).getCertificateChain(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getInitializedKeyStore(String storePath, String storePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        InputStream in = null;
        try {
            File f = new File(storePath);
            in = f.exists() ? new FileInputStream(f) : Thread.currentThread().getContextClassLoader().getResourceAsStream(storePath);
            if (in == null && !"PKCS11".equalsIgnoreCase(keyStoreType)) {
                throw new IOException("Unable to load keystore resource: " + storePath);
            }
            char[] storeCharPassword = storePassword == null ? null : storePassword.toCharArray();
            ks.load(in, storeCharPassword);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return ks;
    }

    public static class QpidClientX509KeyManager
    extends X509ExtendedKeyManager {
        private X509ExtendedKeyManager delegate;
        private String alias;

        public QpidClientX509KeyManager(String alias, String keyStorePath, String keyStoreType, String keyStorePassword, String keyManagerFactoryAlgorithmName) throws GeneralSecurityException, IOException {
            this.alias = alias;
            KeyStore ks = SSLUtil.getInitializedKeyStore(keyStorePath, keyStorePassword, keyStoreType);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithmName);
            kmf.init(ks, keyStorePassword.toCharArray());
            this.delegate = (X509ExtendedKeyManager)kmf.getKeyManagers()[0];
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.alias;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.delegate.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.delegate.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return new String[]{this.alias};
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.delegate.getServerAliases(keyType, issuers);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.alias;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return this.delegate.chooseEngineServerAlias(keyType, issuers, engine);
        }
    }
}

