/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractExtender {
    static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    static final String PACKAGEADMIN_CLASS = "org.osgi.service.packageadmin.PackageAdmin";
    private static ScrConfiguration m_configuration = new ScrConfiguration();
    private static BundleContext m_context;
    private static Bundle m_bundle;
    private static volatile ServiceTracker m_logService;
    private static volatile ServiceTracker m_packageAdmin;
    private Map<Long, BundleComponentActivator> m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;

    public Activator() {
        this.setSynchronous(true);
    }

    public void start(BundleContext context) throws Exception {
        m_context = context;
        m_bundle = context.getBundle();
        super.start(context);
    }

    protected void doStart() throws Exception {
        m_logService = new ServiceTracker(m_context, LOGSERVICE_CLASS, null);
        m_logService.open();
        this.m_componentBundles = new HashMap<Long, BundleComponentActivator>();
        this.m_componentRegistry = new ComponentRegistry(m_context);
        m_configuration.start(m_context);
        Activator.log(3, m_bundle, " Version = {0}", new Object[]{m_bundle.getHeaders().get("Bundle-Version")}, null);
        this.m_componentActor = new ComponentActorThread();
        Thread t = new Thread((Runnable)this.m_componentActor, "SCR Component Actor");
        t.setDaemon(true);
        t.start();
        super.doStart();
        ScrCommand scrCommand = ScrCommand.register(m_context, this.m_componentRegistry, m_configuration);
        m_configuration.setScrCommand(scrCommand);
    }

    public void doStop() throws Exception {
        super.doStop();
        this.m_componentRegistry.dispose();
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            this.m_componentActor = null;
        }
        if (m_logService != null) {
            m_logService.close();
            m_logService = null;
        }
        if (m_packageAdmin != null) {
            m_packageAdmin.close();
            m_packageAdmin = null;
        }
        m_context = null;
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        return new ScrExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponents(Bundle bundle) {
        boolean loaded;
        if (bundle.getHeaders().get("Service-Component") == null) {
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            Activator.log(1, m_bundle, "Cannot get BundleContext of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, null);
            return;
        }
        Long bundleId = bundle.getBundleId();
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            if (this.m_componentBundles.containsKey(bundleId)) {
                loaded = true;
            } else {
                this.m_componentBundles.put(bundleId, null);
                loaded = false;
            }
        }
        if (loaded) {
            Activator.log(4, m_bundle, "Components for bundle {0}/{1} already loaded. Nothing to do.", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, null);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this.m_componentRegistry, this.m_componentActor, context, m_configuration);
            Map<Long, BundleComponentActivator> map2 = this.m_componentBundles;
            synchronized (map2) {
                this.m_componentBundles.put(bundleId, ga);
            }
        }
        catch (Exception e) {
            Map<Long, BundleComponentActivator> map3 = this.m_componentBundles;
            synchronized (map3) {
                this.m_componentBundles.remove(bundleId);
            }
            if (e instanceof IllegalStateException && bundle.getState() != 32) {
                Activator.log(4, m_bundle, "Bundle {0}/{1} has been stopped while trying to activate its components. Trying again when the bundles gets started again.", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
            }
            Activator.log(1, m_bundle, "Error while loading components of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeComponents(Bundle bundle) {
        BundleComponentActivator ga;
        Map<Long, BundleComponentActivator> map = this.m_componentBundles;
        synchronized (map) {
            ga = this.m_componentBundles.remove(bundle.getBundleId());
        }
        if (ga != null) {
            try {
                int reason = this.isStopping() ? 5 : 6;
                ga.dispose(reason);
            }
            catch (Exception e) {
                Activator.log(1, m_bundle, "Error while disposing components of bundle {0}/{1}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId()}, e);
            }
        }
    }

    protected void debug(Bundle bundle, String msg) {
        Activator.log(4, bundle, msg, null);
    }

    protected void warn(Bundle bundle, String msg, Throwable t) {
        Activator.log(2, bundle, msg, t);
    }

    protected void error(String msg, Throwable t) {
        Activator.log(4, m_bundle, msg, t);
    }

    public static void log(int level, Bundle bundle, String pattern, Object[] arguments, Throwable ex) {
        if (Activator.isLogEnabled(level)) {
            String message = MessageFormat.format(pattern, arguments);
            Activator.log(level, bundle, message, ex);
        }
    }

    public static boolean isLogEnabled(int level) {
        return m_configuration.getLogLevel() >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int level, Bundle bundle, String message, Throwable ex) {
        if (Activator.isLogEnabled(level)) {
            Object logger;
            ServiceTracker t = m_logService;
            Object v0 = logger = t != null ? t.getService() : null;
            if (logger == null) {
                PrintStream out = level == 1 ? System.err : System.out;
                StringBuffer buf = new StringBuffer();
                switch (level) {
                    case 4: {
                        buf.append("DEBUG: ");
                        break;
                    }
                    case 3: {
                        buf.append("INFO : ");
                        break;
                    }
                    case 2: {
                        buf.append("WARN : ");
                        break;
                    }
                    case 1: {
                        buf.append("ERROR: ");
                        break;
                    }
                    default: {
                        buf.append("UNK  : ");
                    }
                }
                if (bundle != null) {
                    buf.append(bundle.getSymbolicName());
                    buf.append(" (");
                    buf.append(bundle.getBundleId());
                    buf.append("): ");
                }
                buf.append(message);
                PrintStream printStream = out;
                synchronized (printStream) {
                    out.println(buf);
                    if (ex != null) {
                        ex.printStackTrace(out);
                    }
                }
            } else {
                ((LogService)logger).log(level, message, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getPackageAdmin() {
        if (m_packageAdmin != null) return m_packageAdmin.getService();
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            if (m_packageAdmin != null) return m_packageAdmin.getService();
            m_packageAdmin = new ServiceTracker(m_context, PACKAGEADMIN_CLASS, null);
            m_packageAdmin.open();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_packageAdmin.getService();
        }
    }

    protected class ScrExtension
    implements Extension {
        private final Bundle bundle;
        private final CountDownLatch started;

        public ScrExtension(Bundle bundle) {
            this.bundle = bundle;
            this.started = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            try {
                Activator.this.loadComponents(this.bundle);
                Object var2_1 = null;
                this.started.countDown();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.started.countDown();
                throw throwable;
            }
        }

        public void destroy() {
            try {
                this.started.await(m_configuration.stopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Activator.log(2, m_bundle, "The wait for bundle {0}/{1} being started before destruction has been interrupted.", new Object[]{this.bundle.getSymbolicName(), this.bundle.getBundleId()}, e);
            }
            Activator.this.disposeComponents(this.bundle);
        }
    }
}

