/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.List;
import org.apache.camel.NamedNode;
import org.apache.camel.karaf.commands.CamelCommandSupport;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(scope="camel", name="rest-show", description="Display the Camel REST definition in XML.")
public class RestShow
extends CamelCommandSupport {
    @Argument(index=0, name="context", description="The Camel context name.", required=true, multiValued=false)
    String context;

    public Object doExecute() throws Exception {
        List<RestDefinition> rests = this.camelController.getRestDefinitions(this.context);
        if (rests == null || rests.isEmpty()) {
            System.out.print("There are no REST services in CamelContext with name: " + this.context);
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        System.out.println(ModelHelper.dumpModelAsXml((NamedNode)def));
        return null;
    }
}

