/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.util.Set;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;

public interface ManagedBacklogDebuggerMBean {
    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName();

    @ManagedAttribute(description="Logging Level")
    public String getLoggingLevel();

    @ManagedAttribute(description="Logging Level")
    public void setLoggingLevel(String var1);

    @ManagedAttribute(description="Is debugger enabled")
    public boolean isEnabled();

    @ManagedOperation(description="Enable the debugger")
    public void enableDebugger();

    @ManagedOperation(description="Disable the debugger")
    public void disableDebugger();

    @ManagedOperation(description="Add a breakpoint at the given node id")
    public void addBreakpoint(String var1);

    @ManagedOperation(description="Add a conditional breakpoint at the given node id")
    public void addConditionalBreakpoint(String var1, String var2, String var3);

    @ManagedOperation(description="Remote the breakpoint from the given node id (will resume suspend breakpoint first)")
    public void removeBreakpoint(String var1);

    @ManagedOperation(description="Remote all breakpoints (will resume all suspend breakpoints first and exists single step mode)")
    public void removeAllBreakpoints();

    @ManagedOperation(description="Resume running from the suspended breakpoint at the given node id")
    public void resumeBreakpoint(String var1);

    @ManagedOperation(description="Updates the message body (uses same type as old body) on the suspended breakpoint at the given node id")
    public void setMessageBodyOnBreakpoint(String var1, Object var2);

    @ManagedOperation(description="Updates the message body (with a new type) on the suspended breakpoint at the given node id")
    public void setMessageBodyOnBreakpoint(String var1, Object var2, String var3);

    @ManagedOperation(description="Removes the message body on the suspended breakpoint at the given node id")
    public void removeMessageBodyOnBreakpoint(String var1);

    @ManagedOperation(description="Updates/adds the message header (uses same type as old header value) on the suspended breakpoint at the given node id")
    public void setMessageHeaderOnBreakpoint(String var1, String var2, Object var3);

    @ManagedOperation(description="Removes the message header on the suspended breakpoint at the given node id")
    public void removeMessageHeaderOnBreakpoint(String var1, String var2);

    @ManagedOperation(description="Updates/adds the message header (with a new type) on the suspended breakpoint at the given node id")
    public void setMessageHeaderOnBreakpoint(String var1, String var2, Object var3, String var4);

    @ManagedOperation(description="Resume running any suspended breakpoints, and exits step mode")
    public void resumeAll();

    @ManagedOperation(description="Starts single step debugging from the suspended breakpoint at the given node id")
    public void stepBreakpoint(String var1);

    @ManagedAttribute(description="Whether currently in step mode")
    public boolean isSingleStepMode();

    @ManagedOperation(description="Steps to next node in step mode")
    public void step();

    @ManagedOperation(description="Return the node ids which has breakpoints")
    public Set<String> getBreakpoints();

    @ManagedOperation(description="Return the node ids which is currently suspended")
    public Set<String> getSuspendedBreakpointNodeIds();

    @ManagedOperation(description="Disables a breakpoint")
    public void disableBreakpoint(String var1);

    @ManagedOperation(description="Enables a breakpoint which has been disabled")
    public void enableBreakpoint(String var1);

    @ManagedAttribute(description="Number of maximum chars in the message body in the trace message. Use zero or negative value to have unlimited size.")
    public int getBodyMaxChars();

    @ManagedAttribute(description="Number of maximum chars in the message body in the trace message. Use zero or negative value to have unlimited size.")
    public void setBodyMaxChars(int var1);

    @ManagedAttribute(description="Whether to include stream based message body in the trace message.")
    public boolean isBodyIncludeStreams();

    @ManagedAttribute(description="Whether to include stream based message body in the trace message.")
    public void setBodyIncludeStreams(boolean var1);

    @ManagedAttribute(description="Whether to include file based message body in the trace message.")
    public boolean isBodyIncludeFiles();

    @ManagedAttribute(description="Whether to include file based message body in the trace message.")
    public void setBodyIncludeFiles(boolean var1);

    @ManagedOperation(description="Dumps the messages in xml format from the suspended breakpoint at the given node")
    public String dumpTracedMessagesAsXml(String var1);

    @ManagedAttribute(description="Number of total debugged messages")
    public long getDebugCounter();

    @ManagedOperation(description="Resets the debug counter")
    public void resetDebugCounter();

    @ManagedOperation(description="Used for validating if a given predicate is valid or not")
    public String validateConditionalBreakpoint(String var1, String var2);
}

