/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorDefinitionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessorDefinitionHelper.class);

    private ProcessorDefinitionHelper() {
    }

    public static <T> Iterator<T> filterTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found);
        return found.iterator();
    }

    public static <T> T findFirstTypeInOutputs(List<ProcessorDefinition<?>> outputs, Class<T> type) {
        ArrayList found = new ArrayList();
        ProcessorDefinitionHelper.doFindType(outputs, type, found);
        if (found.isEmpty()) {
            return null;
        }
        return (T)found.iterator().next();
    }

    public static boolean isFirstChildOfType(Class<?> parentType, ProcessorDefinition<?> node) {
        if (node == null || node.getParent() == null) {
            return false;
        }
        if (node.getParent().getOutputs().isEmpty()) {
            return false;
        }
        if (!node.getParent().getClass().equals(parentType)) {
            return false;
        }
        return node.getParent().getOutputs().get(0).equals(node);
    }

    public static boolean isParentOfType(Class<?> parentType, ProcessorDefinition<?> node, boolean recursive) {
        if (node == null || node.getParent() == null) {
            return false;
        }
        if (parentType.isAssignableFrom(node.getParent().getClass())) {
            return true;
        }
        if (recursive) {
            return ProcessorDefinitionHelper.isParentOfType(parentType, node.getParent(), true);
        }
        return false;
    }

    public static RouteDefinition getRoute(ProcessorDefinition<?> node) {
        ProcessorDefinition<?> def;
        if (node == null) {
            return null;
        }
        for (def = node; def != null && def.getParent() != null; def = def.getParent()) {
        }
        if (def instanceof RouteDefinition) {
            return (RouteDefinition)def;
        }
        return null;
    }

    public static String getRouteId(ProcessorDefinition<?> node) {
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(node);
        return route != null ? route.getId() : null;
    }

    public static Set<String> gatherAllNodeIds(ProcessorDefinition<?> node, Set<String> set, boolean onlyCustomId, boolean includeAbstract) {
        List<ProcessorDefinition<?>> children;
        if (node == null) {
            return set;
        }
        if (node.isAbstract() && !includeAbstract) {
            return set;
        }
        if (set == null) {
            set = new LinkedHashSet<String>();
        }
        if (node.getId() != null && (!onlyCustomId || node.hasCustomIdAssigned() && onlyCustomId)) {
            set.add(node.getId());
        }
        if ((children = node.getOutputs()) != null && !children.isEmpty()) {
            for (ProcessorDefinition<?> child : children) {
                ProcessorDefinitionHelper.gatherAllNodeIds(child, set, onlyCustomId, includeAbstract);
            }
        }
        return set;
    }

    private static <T> void doFindType(List<ProcessorDefinition<?>> outputs, Class<T> type, List<T> found) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        for (ProcessorDefinition<?> out : outputs) {
            List<ProcessorDefinition<?>> children;
            if (out instanceof SendDefinition) {
                SendDefinition send = (SendDefinition)out;
                children = send.getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found);
            }
            if (out instanceof ChoiceDefinition) {
                ChoiceDefinition choice = (ChoiceDefinition)out;
                for (WhenDefinition when : choice.getWhenClauses()) {
                    if (type.isInstance(when)) {
                        found.add(when);
                    }
                    List<ProcessorDefinition<?>> children2 = when.getOutputs();
                    ProcessorDefinitionHelper.doFindType(children2, type, found);
                }
                if (choice.getOtherwise() == null) continue;
                children = choice.getOtherwise().getOutputs();
                ProcessorDefinitionHelper.doFindType(children, type, found);
                continue;
            }
            if (out instanceof TryDefinition) {
                TryDefinition doTry = (TryDefinition)out;
                List<ProcessorDefinition<?>> doTryOut = doTry.getOutputsWithoutCatches();
                ProcessorDefinitionHelper.doFindType(doTryOut, type, found);
                List<CatchDefinition> doTryCatch = doTry.getCatchClauses();
                for (CatchDefinition doCatch : doTryCatch) {
                    ProcessorDefinitionHelper.doFindType(doCatch.getOutputs(), type, found);
                }
                if (doTry.getFinallyClause() == null) continue;
                ProcessorDefinitionHelper.doFindType(doTry.getFinallyClause().getOutputs(), type, found);
                continue;
            }
            if (out instanceof OutputDefinition) {
                OutputDefinition outDef = (OutputDefinition)out;
                List<ProcessorDefinition<?>> outDefOut = outDef.getOutputs();
                ProcessorDefinitionHelper.doFindType(outDefOut, type, found);
                continue;
            }
            if (type.isInstance(out)) {
                found.add(out);
            }
            List<ProcessorDefinition<?>> children3 = out.getOutputs();
            ProcessorDefinitionHelper.doFindType(children3, type, found);
        }
    }

    public static boolean hasOutputs(List<ProcessorDefinition<?>> outputs, boolean excludeAbstract) {
        if (outputs == null || outputs.isEmpty()) {
            return false;
        }
        if (!excludeAbstract) {
            return !outputs.isEmpty();
        }
        for (ProcessorDefinition<?> output : outputs) {
            if (output instanceof TransactedDefinition || output instanceof PolicyDefinition) {
                return ProcessorDefinitionHelper.hasOutputs(output.getOutputs(), excludeAbstract);
            }
            if (output.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static boolean willCreateNewThreadPool(RouteContext routeContext, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return false;
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = routeContext.getCamelContext().getRegistry().lookupByNameAndType(definition.getExecutorServiceRef(), ExecutorService.class);
            return answer == null;
        }
        return useDefault;
    }

    public static ExecutorService lookupExecutorServiceRef(RouteContext routeContext, String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ExecutorService answer = routeContext.getCamelContext().getRegistry().lookupByNameAndType(executorServiceRef, ExecutorService.class);
        if (answer == null) {
            answer = manager.newThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public static ExecutorService getConfiguredExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            return definition.getExecutorService();
        }
        if (definition.getExecutorServiceRef() != null) {
            ExecutorService answer = ProcessorDefinitionHelper.lookupExecutorServiceRef(routeContext, name, definition, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultThreadPool(definition, name);
        }
        return null;
    }

    public static ScheduledExecutorService lookupScheduledExecutorServiceRef(RouteContext routeContext, String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        ScheduledExecutorService answer = routeContext.getCamelContext().getRegistry().lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
        if (answer == null) {
            answer = manager.newScheduledThreadPool(source, name, executorServiceRef);
        }
        return answer;
    }

    public static ScheduledExecutorService getConfiguredScheduledExecutorService(RouteContext routeContext, String name, ExecutorServiceAwareDefinition<?> definition, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = routeContext.getCamelContext().getExecutorServiceManager();
        ObjectHelper.notNull(manager, "ExecutorServiceManager", routeContext.getCamelContext());
        if (definition.getExecutorService() != null) {
            ExecutorService executorService = definition.getExecutorService();
            if (executorService instanceof ScheduledExecutorService) {
                return (ScheduledExecutorService)executorService;
            }
            throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " is not an ScheduledExecutorService instance");
        }
        if (definition.getExecutorServiceRef() != null) {
            ScheduledExecutorService answer = ProcessorDefinitionHelper.lookupScheduledExecutorServiceRef(routeContext, name, definition, definition.getExecutorServiceRef());
            if (answer == null) {
                throw new IllegalArgumentException("ExecutorServiceRef " + definition.getExecutorServiceRef() + " not found in registry or as a thread pool profile.");
            }
            return answer;
        }
        if (useDefault) {
            return manager.newDefaultScheduledThreadPool(definition, name);
        }
        return null;
    }

    public static void resolvePropertyPlaceholders(RouteContext routeContext, Object definition) throws Exception {
        Object value;
        LOG.trace("Resolving property placeholders for: {}", definition);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(definition, properties, null);
        ProcessorDefinition processorDefinition = null;
        if (definition instanceof ProcessorDefinition) {
            processorDefinition = (ProcessorDefinition)definition;
        }
        if (processorDefinition != null && processorDefinition.getOtherAttributes() != null) {
            for (QName qName : processorDefinition.getOtherAttributes().keySet()) {
                if (!"http://camel.apache.org/schema/placeholder".equals(qName.getNamespaceURI())) continue;
                String local = qName.getLocalPart();
                value = processorDefinition.getOtherAttributes().get(qName);
                if (value != null && value instanceof String) {
                    String s = (String)value;
                    String prefixToken = routeContext.getCamelContext().getPropertyPrefixToken();
                    String suffixToken = routeContext.getCamelContext().getPropertySuffixToken();
                    if (prefixToken == null) {
                        throw new IllegalArgumentException("Property with name [" + local + "] uses property placeholders; however, no properties component is configured.");
                    }
                    if (!s.startsWith(prefixToken)) {
                        s = prefixToken + s;
                    }
                    if (!s.endsWith(suffixToken)) {
                        s = s + suffixToken;
                    }
                    value = s;
                }
                properties.put(local, value);
            }
        }
        if (!properties.isEmpty()) {
            LOG.trace("There are {} properties on: {}", (Object)properties.size(), definition);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                value = entry.getValue();
                if (!(value instanceof String)) continue;
                String text = (String)value;
                text = routeContext.getCamelContext().resolvePropertyPlaceholders(text);
                if (text == value) continue;
                boolean changed = IntrospectionSupport.setProperty(routeContext.getCamelContext().getTypeConverter(), definition, name, text);
                if (!changed) {
                    throw new IllegalArgumentException("No setter to set property: " + name + " to: " + text + " on: " + definition);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, text});
            }
        }
    }

    public static void resolveKnownConstantFields(Object definition) throws Exception {
        LOG.trace("Resolving known fields for: {}", definition);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(definition, properties, null);
        if (!properties.isEmpty()) {
            LOG.trace("There are {} properties on: {}", (Object)properties.size(), definition);
            for (Map.Entry entry : properties.entrySet()) {
                String text;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String) || !(text = (String)value).startsWith("Exchange.")) continue;
                String field = ObjectHelper.after(text, "Exchange.");
                String constant = ObjectHelper.lookupConstantFieldValue(Exchange.class, field);
                if (constant != null) {
                    IntrospectionSupport.setProperty(definition, name, constant);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, constant});
                    continue;
                }
                throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
            }
        }
    }
}

