/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;

@XmlRootElement(name="xmljson")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XmlJsonDataFormat
extends DataFormatDefinition {
    public static final String TYPE_HINTS = "typeHints";
    public static final String REMOVE_NAMESPACE_PREFIXES = "removeNamespacePrefixes";
    public static final String SKIP_NAMESPACES = "skipNamespaces";
    public static final String TRIM_SPACES = "trimSpaces";
    public static final String SKIP_WHITESPACE = "skipWhitespace";
    public static final String EXPANDABLE_PROPERTIES = "expandableProperties";
    public static final String ARRAY_NAME = "arrayName";
    public static final String ELEMENT_NAME = "elementName";
    public static final String ROOT_NAME = "rootName";
    public static final String NAMESPACE_LENIENT = "namespaceLenient";
    public static final String FORCE_TOP_LEVEL_OBJECT = "forceTopLevelObject";
    public static final String ENCODING = "encoding";
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    private String elementName;
    @XmlAttribute
    private String arrayName;
    @XmlAttribute
    private Boolean forceTopLevelObject;
    @XmlAttribute
    private Boolean namespaceLenient;
    @XmlAttribute
    private String rootName;
    @XmlAttribute
    private Boolean skipWhitespace;
    @XmlAttribute
    private Boolean trimSpaces;
    @XmlAttribute
    private Boolean skipNamespaces;
    @XmlAttribute
    private Boolean removeNamespacePrefixes;
    @XmlAttribute
    @XmlList
    private List<String> expandableProperties;
    @XmlAttribute
    private String typeHints;

    public XmlJsonDataFormat() {
        super("xmljson");
    }

    public XmlJsonDataFormat(Map<String, String> options) {
        super("xmljson");
        if (options.containsKey(ENCODING)) {
            this.encoding = options.get(ENCODING);
        }
        if (options.containsKey(FORCE_TOP_LEVEL_OBJECT)) {
            this.forceTopLevelObject = Boolean.parseBoolean(options.get(FORCE_TOP_LEVEL_OBJECT));
        }
        if (options.containsKey(NAMESPACE_LENIENT)) {
            this.namespaceLenient = Boolean.parseBoolean(options.get(NAMESPACE_LENIENT));
        }
        if (options.containsKey(ROOT_NAME)) {
            this.rootName = options.get(ROOT_NAME);
        }
        if (options.containsKey(ELEMENT_NAME)) {
            this.elementName = options.get(ELEMENT_NAME);
        }
        if (options.containsKey(ARRAY_NAME)) {
            this.arrayName = options.get(ARRAY_NAME);
        }
        if (options.containsKey(EXPANDABLE_PROPERTIES)) {
            this.expandableProperties = Arrays.asList(options.get(EXPANDABLE_PROPERTIES).split(" "));
        }
        if (options.containsKey(SKIP_WHITESPACE)) {
            this.skipWhitespace = Boolean.parseBoolean(options.get(SKIP_WHITESPACE));
        }
        if (options.containsKey(TRIM_SPACES)) {
            this.trimSpaces = Boolean.parseBoolean(options.get(TRIM_SPACES));
        }
        if (options.containsKey(SKIP_NAMESPACES)) {
            this.skipNamespaces = Boolean.parseBoolean(options.get(SKIP_NAMESPACES));
        }
        if (options.containsKey(REMOVE_NAMESPACE_PREFIXES)) {
            this.removeNamespacePrefixes = Boolean.parseBoolean(options.get(REMOVE_NAMESPACE_PREFIXES));
        }
        if (options.containsKey(TYPE_HINTS)) {
            this.typeHints = options.get(TYPE_HINTS);
        }
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.encoding != null) {
            this.setProperty(camelContext, dataFormat, ENCODING, this.encoding);
        }
        if (this.forceTopLevelObject != null) {
            this.setProperty(camelContext, dataFormat, FORCE_TOP_LEVEL_OBJECT, this.forceTopLevelObject);
        }
        if (this.namespaceLenient != null) {
            this.setProperty(camelContext, dataFormat, NAMESPACE_LENIENT, this.namespaceLenient);
        }
        if (this.rootName != null) {
            this.setProperty(camelContext, dataFormat, ROOT_NAME, this.rootName);
        }
        if (this.elementName != null) {
            this.setProperty(camelContext, dataFormat, ELEMENT_NAME, this.elementName);
        }
        if (this.arrayName != null) {
            this.setProperty(camelContext, dataFormat, ARRAY_NAME, this.arrayName);
        }
        if (this.expandableProperties != null && this.expandableProperties.size() != 0) {
            this.setProperty(camelContext, dataFormat, EXPANDABLE_PROPERTIES, this.expandableProperties);
        }
        if (this.skipWhitespace != null) {
            this.setProperty(camelContext, dataFormat, SKIP_WHITESPACE, this.skipWhitespace);
        }
        if (this.trimSpaces != null) {
            this.setProperty(camelContext, dataFormat, TRIM_SPACES, this.trimSpaces);
        }
        if (this.skipNamespaces != null) {
            this.setProperty(camelContext, dataFormat, SKIP_NAMESPACES, this.skipNamespaces);
        }
        if (this.removeNamespacePrefixes != null) {
            this.setProperty(camelContext, dataFormat, REMOVE_NAMESPACE_PREFIXES, this.removeNamespacePrefixes);
        }
        if (this.typeHints != null) {
            this.setProperty(camelContext, this.typeHints, TYPE_HINTS, this.typeHints);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public Boolean getForceTopLevelObject() {
        return this.forceTopLevelObject;
    }

    public void setForceTopLevelObject(Boolean forceTopLevelObject) {
        this.forceTopLevelObject = forceTopLevelObject;
    }

    public Boolean getNamespaceLenient() {
        return this.namespaceLenient;
    }

    public void setNamespaceLenient(Boolean namespaceLenient) {
        this.namespaceLenient = namespaceLenient;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public Boolean getSkipWhitespace() {
        return this.skipWhitespace;
    }

    public void setSkipWhitespace(Boolean skipWhitespace) {
        this.skipWhitespace = skipWhitespace;
    }

    public Boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(Boolean trimSpaces) {
        this.trimSpaces = trimSpaces;
    }

    public Boolean getSkipNamespaces() {
        return this.skipNamespaces;
    }

    public void setSkipNamespaces(Boolean skipNamespaces) {
        this.skipNamespaces = skipNamespaces;
    }

    public Boolean getRemoveNamespacePrefixes() {
        return this.removeNamespacePrefixes;
    }

    public void setRemoveNamespacePrefixes(Boolean removeNamespacePrefixes) {
        this.removeNamespacePrefixes = removeNamespacePrefixes;
    }

    public List<String> getExpandableProperties() {
        return this.expandableProperties;
    }

    public void setExpandableProperties(List<String> expandableProperties) {
        this.expandableProperties = expandableProperties;
    }

    public String getTypeHints() {
        return this.typeHints;
    }

    public void setTypeHints(String typeHints) {
        this.typeHints = typeHints;
    }
}

