/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.binding;

import java.util.Locale;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.processor.MarshalProcessor;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.processor.binding.BindingException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;

public class RestBindingProcessor
extends ServiceSupport
implements AsyncProcessor {
    private final AsyncProcessor jsonUnmarshal;
    private final AsyncProcessor xmlUnmarshal;
    private final AsyncProcessor jsonMarshal;
    private final AsyncProcessor xmlMarshal;
    private final String consumes;
    private final String produces;
    private final String bindingMode;
    private final boolean skipBindingOnErrorCode;

    public RestBindingProcessor(DataFormat jsonDataFormat, DataFormat xmlDataFormat, DataFormat outJsonDataFormat, DataFormat outXmlDataFormat, String consumes, String produces, String bindingMode, boolean skipBindingOnErrorCode) {
        this.jsonUnmarshal = jsonDataFormat != null ? new UnmarshalProcessor(jsonDataFormat) : null;
        this.jsonMarshal = outJsonDataFormat != null ? new MarshalProcessor(outJsonDataFormat) : (jsonDataFormat != null ? new MarshalProcessor(jsonDataFormat) : null);
        this.xmlUnmarshal = xmlDataFormat != null ? new UnmarshalProcessor(xmlDataFormat) : null;
        this.xmlMarshal = outXmlDataFormat != null ? new MarshalProcessor(outXmlDataFormat) : (xmlDataFormat != null ? new MarshalProcessor(xmlDataFormat) : null);
        this.consumes = consumes;
        this.produces = produces;
        this.bindingMode = bindingMode;
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.bindingMode == null || "off".equals(this.bindingMode)) {
            callback.done(true);
            return true;
        }
        if (this.jsonUnmarshal == null && this.xmlUnmarshal == null) {
            callback.done(true);
            return true;
        }
        boolean isXml = false;
        boolean isJson = false;
        String accept = exchange.getIn().getHeader("Accept", String.class);
        String contentType = ExchangeHelper.getContentType(exchange);
        if (contentType != null) {
            isXml = contentType.toLowerCase(Locale.US).contains("xml");
            isJson = contentType.toLowerCase(Locale.US).contains("json");
        }
        if (!isXml && !isJson) {
            isXml = this.consumes != null && this.consumes.toLowerCase(Locale.US).contains("xml");
            isJson = this.consumes != null && this.consumes.toLowerCase(Locale.US).contains("json");
        }
        if (!(isJson &= this.bindingMode.equals("auto") || this.bindingMode.contains("json")) && !(isXml &= this.bindingMode.equals("auto") || this.bindingMode.contains("xml"))) {
            isXml = this.bindingMode.equals("auto") || this.bindingMode.contains("xml");
            isJson = this.bindingMode.equals("auto") || this.bindingMode.contains("json");
        }
        String body = null;
        if (exchange.getIn().getBody() != null && (isXml || isJson) && (body = MessageHelper.extractBodyAsString(exchange.getIn())) != null) {
            exchange.getIn().setBody(body);
            if (isXml && isJson) {
                isXml = body.startsWith("<");
                boolean bl = isJson = !isXml;
            }
        }
        if (isJson && this.jsonUnmarshal != null) {
            exchange.addOnCompletion(new RestBindingMarshalOnCompletion(exchange.getFromRouteId(), this.jsonMarshal, this.xmlMarshal, false, accept));
            if (ObjectHelper.isNotEmpty(body)) {
                return this.jsonUnmarshal.process(exchange, callback);
            }
            callback.done(true);
            return true;
        }
        if (isXml && this.xmlUnmarshal != null) {
            exchange.addOnCompletion(new RestBindingMarshalOnCompletion(exchange.getFromRouteId(), this.jsonMarshal, this.xmlMarshal, true, accept));
            if (ObjectHelper.isNotEmpty(body)) {
                return this.xmlUnmarshal.process(exchange, callback);
            }
            callback.done(true);
            return true;
        }
        if (this.bindingMode.equals("auto")) {
            exchange.addOnCompletion(new RestBindingMarshalOnCompletion(exchange.getFromRouteId(), this.jsonMarshal, this.xmlMarshal, false, accept));
            callback.done(true);
            return true;
        }
        if (this.bindingMode.contains("xml")) {
            exchange.setException(new BindingException("Cannot bind to xml as message body is not xml compatible", exchange));
        } else {
            exchange.setException(new BindingException("Cannot bind to json as message body is not json compatible", exchange));
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "RestBindingProcessor";
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    private final class RestBindingMarshalOnCompletion
    extends SynchronizationAdapter {
        private final AsyncProcessor jsonMarshal;
        private final AsyncProcessor xmlMarshal;
        private final String routeId;
        private boolean wasXml;
        private String accept;

        private RestBindingMarshalOnCompletion(String routeId, AsyncProcessor jsonMarshal, AsyncProcessor xmlMarshal, boolean wasXml, String accept) {
            this.routeId = routeId;
            this.jsonMarshal = jsonMarshal;
            this.xmlMarshal = xmlMarshal;
            this.wasXml = wasXml;
            this.accept = accept;
        }

        @Override
        public void onAfterRoute(Route route, Exchange exchange) {
            String contentType;
            if (!this.routeId.equals(route.getId())) {
                return;
            }
            if (exchange.getException() != null) {
                return;
            }
            if (RestBindingProcessor.this.skipBindingOnErrorCode) {
                Integer code;
                Integer n = code = exchange.hasOut() ? exchange.getOut().getHeader("CamelHttpResponseCode", Integer.class) : exchange.getIn().getHeader("CamelHttpResponseCode", Integer.class);
                if (code != null && code >= 300) {
                    return;
                }
            }
            if (RestBindingProcessor.this.bindingMode == null || "off".equals(RestBindingProcessor.this.bindingMode)) {
                return;
            }
            if (this.jsonMarshal == null && this.xmlMarshal == null) {
                return;
            }
            if (exchange.hasOut() && exchange.getOut().getBody() == null || !exchange.hasOut() && exchange.getIn().getBody() == null) {
                return;
            }
            boolean isXml = false;
            boolean isJson = false;
            if (this.accept != null) {
                isXml = this.accept.toLowerCase(Locale.US).contains("xml");
                isJson = this.accept.toLowerCase(Locale.US).contains("json");
            }
            if (!isXml && !isJson && (contentType = ExchangeHelper.getContentType(exchange)) != null) {
                isXml = contentType.toLowerCase(Locale.US).contains("xml");
                isJson = contentType.toLowerCase(Locale.US).contains("json");
            }
            if (!isXml && !isJson) {
                isXml = RestBindingProcessor.this.produces != null && RestBindingProcessor.this.produces.toLowerCase(Locale.US).contains("xml");
                isJson = RestBindingProcessor.this.produces != null && RestBindingProcessor.this.produces.toLowerCase(Locale.US).contains("json");
            }
            if (!(isJson &= RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("json")) && !(isXml &= RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("xml"))) {
                isXml = RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("xml");
                boolean bl = isJson = RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("json");
            }
            if (isXml && isJson) {
                isXml = this.wasXml;
                isJson = !this.wasXml;
            }
            ExchangeHelper.prepareOutToIn(exchange);
            try {
                String type;
                if (isJson && this.jsonMarshal != null) {
                    type = ExchangeHelper.getContentType(exchange);
                    if (type == null) {
                        exchange.getIn().setHeader("Content-Type", "application/json");
                    }
                    this.jsonMarshal.process(exchange);
                } else if (isXml && this.xmlMarshal != null) {
                    type = ExchangeHelper.getContentType(exchange);
                    if (type == null) {
                        exchange.getIn().setHeader("Content-Type", "application/xml");
                    }
                    this.xmlMarshal.process(exchange);
                } else if (!RestBindingProcessor.this.bindingMode.equals("auto")) {
                    if (RestBindingProcessor.this.bindingMode.contains("xml")) {
                        exchange.setException(new BindingException("Cannot bind to xml as message body is not xml compatible", exchange));
                    } else {
                        exchange.setException(new BindingException("Cannot bind to json as message body is not json compatible", exchange));
                    }
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
        }
    }
}

