/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Stack;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    public static final int BUFFER_SIZE = 131072;
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static final String USER_DIR_KEY = "user.dir";
    private static final File USER_DIR = new File(System.getProperty("user.dir"));
    private static File defaultTempDir;
    private static Thread shutdownHook;
    private static boolean windowsOs;

    private FileUtil() {
    }

    private static boolean initWindowsOs() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains("windows");
    }

    public static File getUserDir() {
        return USER_DIR;
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if (FileUtil.isWindows()) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }

    public static boolean isWindows() {
        return windowsOs;
    }

    @Deprecated
    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File parent;
        File file = parent = parentDir == null ? FileUtil.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "camel";
        } else if (prefix.length() < 3) {
            prefix = prefix + "camel";
        }
        parent.mkdirs();
        return File.createTempFile(prefix, suffix, parent);
    }

    public static String stripLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static boolean hasLeadingSeparator(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith("/") || name.startsWith(File.separator);
    }

    public static String stripFirstLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String stripTrailingSeparator(String name) {
        if (ObjectHelper.isEmpty(name)) {
            return name;
        }
        String s = name;
        while (s.endsWith("/") || s.endsWith(File.separator)) {
            s = s.substring(0, s.length() - 1);
        }
        if (ObjectHelper.isEmpty(s)) {
            return name;
        }
        return s;
    }

    public static String stripPath(String name) {
        int posWin;
        if (name == null) {
            return null;
        }
        int posUnix = name.lastIndexOf(47);
        int pos = Math.max(posUnix, posWin = name.lastIndexOf(92));
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static String stripExt(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static String onlyPath(String name) {
        int posWin;
        if (name == null) {
            return null;
        }
        int posUnix = name.lastIndexOf(47);
        int pos = Math.max(posUnix, posWin = name.lastIndexOf(92));
        if (pos > 0) {
            return name.substring(0, pos);
        }
        if (pos == 0) {
            return name.substring(0, 1);
        }
        return null;
    }

    public static String compactPath(String path) {
        return FileUtil.compactPath(path, File.separatorChar);
    }

    public static String compactPath(String path, char separator) {
        String[] parts;
        if (path == null) {
            return null;
        }
        if (path.indexOf(47) == -1 && path.indexOf(92) == -1) {
            return path;
        }
        boolean endsWithSlash = (path = FileUtil.normalizePath(path)).endsWith("/") || path.endsWith("\\");
        boolean startsWithSlash = path.startsWith("/") || path.startsWith("\\");
        Stack<String> stack = new Stack<String>();
        String separatorRegex = "\\\\|/";
        for (String part : parts = path.split(separatorRegex)) {
            if (part.equals("..") && !stack.isEmpty() && !"..".equals(stack.peek())) {
                stack.pop();
                continue;
            }
            if (part.equals(".") || part.isEmpty()) continue;
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        if (startsWithSlash) {
            sb.append(separator);
        }
        Iterator it = stack.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        if (endsWithSlash && stack.size() > 0) {
            sb.append(separator);
        }
        return sb.toString();
    }

    @Deprecated
    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        defaultTempDir = FileUtil.createNewTempDir();
        shutdownHook = new Thread(){

            @Override
            public void run() {
                FileUtil.removeDir(defaultTempDir);
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return defaultTempDir;
    }

    @Deprecated
    private static File createNewTempDir() {
        String s = System.getProperty("java.io.tmpdir");
        File checkExists = new File(s);
        if (!checkExists.exists()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
        }
        if (!checkExists.canWrite()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " is not writable, please set java.io.tempdir" + " to a writable directory");
        }
        Random ran = new Random();
        int x = ran.nextInt(1000000);
        File f = new File(s, "camel-tmp-" + x);
        int count = 0;
        while (!f.mkdir()) {
            if (++count >= 100) {
                throw new RuntimeException("Camel cannot a temp directory from" + checkExists.getAbsolutePath() + " 100 times , please set java.io.tempdir" + " to a writable directory");
            }
            x = ran.nextInt(1000000);
            f = new File(s, "camel-tmp-" + x);
        }
        return f;
    }

    @Deprecated
    public static synchronized void shutdown() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            FileUtil.removeDir(defaultTempDir);
        }
        if (shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            shutdownHook = null;
        }
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (String s : list) {
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtil.removeDir(f);
                continue;
            }
            FileUtil.delete(f);
        }
        FileUtil.delete(d);
    }

    private static void delete(File f) {
        if (!f.delete()) {
            if (FileUtil.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    public static boolean renameFile(File from, File to, boolean copyAndDeleteOnRenameFail) throws IOException {
        int count;
        if (!from.exists()) {
            return false;
        }
        boolean renamed = false;
        for (count = 0; !renamed && count < 3; ++count) {
            if (LOG.isDebugEnabled() && count > 0) {
                LOG.debug("Retrying attempt {} to rename file from: {} to: {}", new Object[]{count, from, to});
            }
            if ((renamed = from.renameTo(to)) || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!renamed && copyAndDeleteOnRenameFail) {
            LOG.debug("Cannot rename file from: {} to: {}, will now use a copy/delete approach instead", (Object)from, (Object)to);
            renamed = FileUtil.renameFileUsingCopy(from, to);
        }
        if (LOG.isDebugEnabled() && count > 0) {
            LOG.debug("Tried {} to rename file: {} to: {} with result: {}", new Object[]{count, from, to, renamed});
        }
        return renamed;
    }

    public static boolean renameFileUsingCopy(File from, File to) throws IOException {
        if (!from.exists()) {
            return false;
        }
        LOG.debug("Rename file '{}' to '{}' using copy/delete strategy.", (Object)from, (Object)to);
        FileUtil.copyFile(from, to);
        if (!FileUtil.deleteFile(from)) {
            throw new IOException("Renaming file from '" + from + "' to '" + to + "' failed: Cannot delete file '" + from + "' after copy succeeded");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        try {
            in = new FileInputStream(from).getChannel();
            out = new FileOutputStream(to).getChannel();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using FileChannel to copy from: " + in + " to: " + out);
            }
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, 131072L, out)) {
            }
        }
        finally {
            IOHelper.close((Closeable)in, from.getName(), LOG);
            IOHelper.close((Closeable)out, to.getName(), LOG);
        }
    }

    public static boolean deleteFile(File file) {
        int count;
        if (!file.exists()) {
            return false;
        }
        boolean deleted = false;
        for (count = 0; !deleted && count < 3; ++count) {
            LOG.debug("Retrying attempt {} to delete file: {}", (Object)count, (Object)file);
            deleted = file.delete();
            if (deleted || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (LOG.isDebugEnabled() && count > 0) {
            LOG.debug("Tried {} to delete file: {} with result: {}", new Object[]{count, file, deleted});
        }
        return deleted;
    }

    public static boolean isAbsolute(File file) {
        String path;
        if (FileUtil.isWindows() && (path = file.getPath()).startsWith(File.separator)) {
            return true;
        }
        return file.isAbsolute();
    }

    public static boolean createNewFile(File file) throws IOException {
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            if (file.exists()) {
                return true;
            }
            throw e;
        }
    }

    static {
        windowsOs = FileUtil.initWindowsOs();
    }
}

