/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.fusesource.hawtbuf.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpNioTransportHelper {
    private final DataInputStream amqpHeaderValue = new DataInputStream(new ByteArrayInputStream(new byte[]{65, 77, 81, 80}));
    private final Integer AMQP_HEADER_VALUE = this.amqpHeaderValue.readInt();
    private static final Logger LOG = LoggerFactory.getLogger(AmqpNioTransportHelper.class);
    protected int nextFrameSize = -1;
    protected ByteBuffer currentBuffer;
    private boolean magicConsumed = false;
    private final TransportSupport transportSupport;

    public AmqpNioTransportHelper(TransportSupport transportSupport) throws IOException {
        this.transportSupport = transportSupport;
    }

    protected void processCommand(ByteBuffer plain) throws Exception {
        if (this.nextFrameSize == -1) {
            if (plain.remaining() < 4) {
                if (this.currentBuffer == null) {
                    this.currentBuffer = ByteBuffer.allocate(4);
                }
                while (this.currentBuffer.hasRemaining() && plain.hasRemaining()) {
                    this.currentBuffer.put(plain.get());
                }
                if (this.currentBuffer.hasRemaining()) {
                    return;
                }
                this.currentBuffer.flip();
                this.nextFrameSize = this.currentBuffer.getInt();
            } else if (this.currentBuffer != null) {
                while (this.currentBuffer.hasRemaining()) {
                    this.currentBuffer.put(plain.get());
                }
                this.currentBuffer.flip();
                this.nextFrameSize = this.currentBuffer.getInt();
            } else {
                this.nextFrameSize = plain.getInt();
            }
        }
        while (true) {
            if (this.nextFrameSize == this.AMQP_HEADER_VALUE) {
                this.nextFrameSize = this.handleAmqpHeader(plain);
                if (this.nextFrameSize == -1) {
                    return;
                }
            }
            this.validateFrameSize(this.nextFrameSize);
            if (this.currentBuffer == null || this.currentBuffer.limit() == 4) {
                this.currentBuffer = ByteBuffer.allocate(this.nextFrameSize);
                this.currentBuffer.putInt(this.nextFrameSize);
            }
            if (this.currentBuffer.remaining() >= plain.remaining()) {
                this.currentBuffer.put(plain);
            } else {
                byte[] fill = new byte[this.currentBuffer.remaining()];
                plain.get(fill);
                this.currentBuffer.put(fill);
            }
            if (this.currentBuffer.hasRemaining()) {
                return;
            }
            this.currentBuffer.flip();
            LOG.debug("Calling doConsume with position {} limit {}", (Object)this.currentBuffer.position(), (Object)this.currentBuffer.limit());
            this.transportSupport.doConsume(AmqpSupport.toBuffer(this.currentBuffer));
            this.currentBuffer = null;
            this.nextFrameSize = -1;
            if (!plain.hasRemaining()) break;
            if (plain.remaining() < 4) {
                this.currentBuffer = ByteBuffer.allocate(4);
                while (this.currentBuffer.hasRemaining() && plain.hasRemaining()) {
                    this.currentBuffer.put(plain.get());
                }
                return;
            }
            this.nextFrameSize = plain.getInt();
        }
    }

    private void validateFrameSize(int frameSize) throws IOException {
        if ((long)this.nextFrameSize > Long.MAX_VALUE) {
            throw new IOException("Frame size of " + this.nextFrameSize + "larger than max allowed " + Long.MAX_VALUE);
        }
    }

    private int handleAmqpHeader(ByteBuffer plain) {
        LOG.debug("Consuming AMQP_HEADER");
        this.currentBuffer = ByteBuffer.allocate(8);
        this.currentBuffer.putInt(this.AMQP_HEADER_VALUE);
        while (this.currentBuffer.hasRemaining()) {
            this.currentBuffer.put(plain.get());
        }
        this.currentBuffer.flip();
        if (!this.magicConsumed) {
            this.transportSupport.doConsume(new AmqpHeader(new Buffer(this.currentBuffer)));
            this.magicConsumed = true;
        } else {
            this.transportSupport.doConsume(AmqpSupport.toBuffer(this.currentBuffer));
        }
        this.currentBuffer = null;
        int nextFrameSize = plain.hasRemaining() ? (plain.remaining() < 4 ? 4 : plain.getInt()) : -1;
        return nextFrameSize;
    }
}

