/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.util.CamelContextHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelRedeliveryPolicyFactoryBean
extends AbstractCamelFactoryBean<RedeliveryPolicy> {
    @XmlAttribute
    private String maximumRedeliveries;
    @XmlAttribute
    private String redeliveryDelay;
    @XmlAttribute
    private String asyncDelayedRedelivery;
    @XmlAttribute
    private String backOffMultiplier;
    @XmlAttribute
    private String useExponentialBackOff;
    @XmlAttribute
    private String collisionAvoidanceFactor;
    @XmlAttribute
    private String useCollisionAvoidance;
    @XmlAttribute
    private String maximumRedeliveryDelay;
    @XmlAttribute
    private LoggingLevel retriesExhaustedLogLevel;
    @XmlAttribute
    private LoggingLevel retryAttemptedLogLevel;
    @XmlAttribute
    private String logRetryAttempted;
    @XmlAttribute
    private String logStackTrace;
    @XmlAttribute
    private String logRetryStackTrace;
    @XmlAttribute
    private String logHandled;
    @XmlAttribute
    private String logContinued;
    @XmlAttribute
    private String logExhausted;
    @XmlAttribute
    private String disableRedelivery;
    @XmlAttribute
    private String delayPattern;
    @XmlAttribute
    private String allowRedeliveryWhileStopping;

    @Override
    public RedeliveryPolicy getObject() throws Exception {
        RedeliveryPolicy answer = new RedeliveryPolicy();
        CamelContext context = this.getCamelContext();
        if (this.maximumRedeliveries != null) {
            answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)this.maximumRedeliveries).intValue());
        }
        if (this.redeliveryDelay != null) {
            answer.setRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)this.redeliveryDelay).longValue());
        }
        if (this.asyncDelayedRedelivery != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)this.asyncDelayedRedelivery).booleanValue()) {
            answer.asyncDelayedRedelivery();
        }
        if (this.retriesExhaustedLogLevel != null) {
            answer.setRetriesExhaustedLogLevel(this.retriesExhaustedLogLevel);
        }
        if (this.retryAttemptedLogLevel != null) {
            answer.setRetryAttemptedLogLevel(this.retryAttemptedLogLevel);
        }
        if (this.backOffMultiplier != null) {
            answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)this.backOffMultiplier).doubleValue());
        }
        if (this.useExponentialBackOff != null) {
            answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.useExponentialBackOff).booleanValue());
        }
        if (this.collisionAvoidanceFactor != null) {
            answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)this.collisionAvoidanceFactor).doubleValue());
        }
        if (this.useCollisionAvoidance != null) {
            answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.useCollisionAvoidance).booleanValue());
        }
        if (this.maximumRedeliveryDelay != null) {
            answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)this.maximumRedeliveryDelay).longValue());
        }
        if (this.logStackTrace != null) {
            answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logStackTrace).booleanValue());
        }
        if (this.logRetryStackTrace != null) {
            answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logRetryStackTrace).booleanValue());
        }
        if (this.logHandled != null) {
            answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logHandled).booleanValue());
        }
        if (this.logContinued != null) {
            answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logContinued).booleanValue());
        }
        if (this.logRetryAttempted != null) {
            answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logRetryAttempted).booleanValue());
        }
        if (this.logExhausted != null) {
            answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.logExhausted).booleanValue());
        }
        if (this.disableRedelivery != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)this.disableRedelivery).booleanValue()) {
            answer.setMaximumRedeliveries(0);
        }
        if (this.delayPattern != null) {
            answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)this.delayPattern));
        }
        if (this.allowRedeliveryWhileStopping != null) {
            answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)this.allowRedeliveryWhileStopping).booleanValue());
        }
        return answer;
    }

    @Override
    public Class<RedeliveryPolicy> getObjectType() {
        return RedeliveryPolicy.class;
    }

    public String getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(String maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(String redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public String getAsyncDelayedRedelivery() {
        return this.asyncDelayedRedelivery;
    }

    public void setAsyncDelayedRedelivery(String asyncDelayedRedelivery) {
        this.asyncDelayedRedelivery = asyncDelayedRedelivery;
    }

    public String getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(String backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public String getUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(String useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    public String getCollisionAvoidanceFactor() {
        return this.collisionAvoidanceFactor;
    }

    public void setCollisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.collisionAvoidanceFactor = collisionAvoidanceFactor;
    }

    public String getUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(String useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public String getMaximumRedeliveryDelay() {
        return this.maximumRedeliveryDelay;
    }

    public void setMaximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.maximumRedeliveryDelay = maximumRedeliveryDelay;
    }

    public LoggingLevel getRetriesExhaustedLogLevel() {
        return this.retriesExhaustedLogLevel;
    }

    public void setRetriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.retriesExhaustedLogLevel = retriesExhaustedLogLevel;
    }

    public LoggingLevel getRetryAttemptedLogLevel() {
        return this.retryAttemptedLogLevel;
    }

    public void setRetryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.retryAttemptedLogLevel = retryAttemptedLogLevel;
    }

    public String getLogRetryAttempted() {
        return this.logRetryAttempted;
    }

    public void setLogRetryAttempted(String logRetryAttempted) {
        this.logRetryAttempted = logRetryAttempted;
    }

    public String getLogStackTrace() {
        return this.logStackTrace;
    }

    public void setLogStackTrace(String logStackTrace) {
        this.logStackTrace = logStackTrace;
    }

    public String getLogRetryStackTrace() {
        return this.logRetryStackTrace;
    }

    public void setLogRetryStackTrace(String logRetryStackTrace) {
        this.logRetryStackTrace = logRetryStackTrace;
    }

    public String getLogHandled() {
        return this.logHandled;
    }

    public void setLogHandled(String logHandled) {
        this.logHandled = logHandled;
    }

    public String getLogContinued() {
        return this.logContinued;
    }

    public void setLogContinued(String logContinued) {
        this.logContinued = logContinued;
    }

    public String getLogExhausted() {
        return this.logExhausted;
    }

    public void setLogExhausted(String logExhausted) {
        this.logExhausted = logExhausted;
    }

    public String getDisableRedelivery() {
        return this.disableRedelivery;
    }

    public void setDisableRedelivery(String disableRedelivery) {
        this.disableRedelivery = disableRedelivery;
    }

    public String getDelayPattern() {
        return this.delayPattern;
    }

    public void setDelayPattern(String delayPattern) {
        this.delayPattern = delayPattern;
    }

    public String getAllowRedeliveryWhileStopping() {
        return this.allowRedeliveryWhileStopping;
    }

    public void setAllowRedeliveryWhileStopping(String allowRedeliveryWhileStopping) {
        this.allowRedeliveryWhileStopping = allowRedeliveryWhileStopping;
    }
}

