/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.FelixPropertyAdapter;
import org.apache.felix.bundlerepository.impl.NamespaceTranslator;
import org.apache.felix.bundlerepository.impl.PullParser;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.RequirementImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.osgi.framework.Version;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecXMLPullParser {
    private static final String ATTRIBUTE = "attribute";
    private static final String CAPABILITY = "capability";
    private static final String DIRECTIVE = "directive";
    private static final String INCREMENT = "increment";
    private static final String NAME = "name";
    private static final String NAMESPACE = "namespace";
    private static final String REFERRAL = "referral";
    private static final String REPOSITORY = "repository";
    private static final String REQUIREMENT = "requirement";
    private static final String RESOURCE = "resource";

    public static RepositoryImpl parse(XmlPullParser reader) throws Exception {
        int event;
        RepositoryImpl repository = new RepositoryImpl();
        int ac = reader.getAttributeCount();
        for (int i = 0; i < ac; ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            if (NAME.equals(name)) {
                repository.setName(value);
                continue;
            }
            if (!INCREMENT.equals(name)) continue;
            repository.setLastModified(value);
        }
        while ((event = reader.nextTag()) == 2) {
            String element = reader.getName();
            if (REFERRAL.equals(element)) continue;
            if (RESOURCE.equals(element)) {
                Resource resource = SpecXMLPullParser.parseResource(reader);
                repository.addResource(resource);
                continue;
            }
            PullParser.ignoreTag(reader);
        }
        PullParser.sanityCheckEndElement(reader, event, REPOSITORY);
        return repository;
    }

    private static Resource parseResource(XmlPullParser reader) throws Exception {
        ResourceImpl resource = new ResourceImpl();
        try {
            int event;
            while ((event = reader.nextTag()) == 2) {
                String element = reader.getName();
                if (CAPABILITY.equals(element)) {
                    Capability capability = SpecXMLPullParser.parseCapability(reader, resource);
                    if (capability == null) continue;
                    resource.addCapability(capability);
                    continue;
                }
                if (REQUIREMENT.equals(element)) {
                    Requirement requirement = SpecXMLPullParser.parseRequirement(reader);
                    resource.addRequire(requirement);
                    continue;
                }
                PullParser.ignoreTag(reader);
            }
            PullParser.sanityCheckEndElement(reader, event, RESOURCE);
            return resource;
        }
        catch (Exception e) {
            throw new Exception("Error while parsing resource " + resource.getId() + " at line " + reader.getLineNumber() + " and column " + reader.getColumnNumber(), e);
        }
    }

    private static Capability parseCapability(XmlPullParser reader, ResourceImpl resource) throws Exception {
        String namespace = reader.getAttributeValue(null, NAMESPACE);
        if ("osgi.identity".equals(namespace)) {
            SpecXMLPullParser.parseIdentityNamespace(reader, resource);
            return null;
        }
        if ("osgi.content".equals(namespace) && resource.getURI() == null) {
            SpecXMLPullParser.parseContentNamespace(reader, resource);
            return null;
        }
        CapabilityImpl capability = new CapabilityImpl();
        if (!namespace.equals(NamespaceTranslator.getOSGiNamespace(namespace))) {
            throw new Exception("Namespace conflict. Namespace not allowed: " + namespace);
        }
        capability.setName(NamespaceTranslator.getFelixNamespace(namespace));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        HashMap<String, String> directives = new HashMap<String, String>();
        SpecXMLPullParser.parseAttributesDirectives(reader, attributes, directives, CAPABILITY);
        for (Map.Entry entry : attributes.entrySet()) {
            capability.addProperty(new FelixPropertyAdapter((String)entry.getKey(), entry.getValue()));
        }
        for (Map.Entry entry : directives.entrySet()) {
            capability.addDirective((String)entry.getKey(), (String)entry.getValue());
        }
        return capability;
    }

    private static void parseIdentityNamespace(XmlPullParser reader, ResourceImpl resource) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        SpecXMLPullParser.parseAttributesDirectives(reader, attributes, new HashMap<String, String>(), CAPABILITY);
        for (Map.Entry entry : attributes.entrySet()) {
            if ("osgi.identity".equals(entry.getKey())) {
                resource.put("symbolicname", entry.getValue());
                continue;
            }
            resource.put(entry.getKey(), entry.getValue());
        }
    }

    private static void parseContentNamespace(XmlPullParser reader, ResourceImpl resource) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        SpecXMLPullParser.parseAttributesDirectives(reader, attributes, new HashMap<String, String>(), CAPABILITY);
        for (Map.Entry entry : attributes.entrySet()) {
            if ("osgi.content".equals(entry.getKey())) continue;
            if ("url".equals(entry.getKey())) {
                resource.put("uri", entry.getValue());
                continue;
            }
            resource.put(entry.getKey(), entry.getValue());
        }
    }

    private static void parseAttributesDirectives(XmlPullParser reader, Map<String, Object> attributes, Map<String, String> directives, String parentTag) throws XmlPullParserException, IOException {
        int event;
        while ((event = reader.nextTag()) == 2) {
            String name;
            String element = reader.getName();
            if (ATTRIBUTE.equals(element)) {
                name = reader.getAttributeValue(null, NAME);
                String type = reader.getAttributeValue(null, "type");
                String value = reader.getAttributeValue(null, "value");
                attributes.put(name, SpecXMLPullParser.getTypedValue(type, value));
                PullParser.sanityCheckEndElement(reader, reader.nextTag(), ATTRIBUTE);
                continue;
            }
            if (DIRECTIVE.equals(element)) {
                name = reader.getAttributeValue(null, NAME);
                String value = reader.getAttributeValue(null, "value");
                directives.put(name, value);
                PullParser.sanityCheckEndElement(reader, reader.nextTag(), DIRECTIVE);
                continue;
            }
            PullParser.ignoreTag(reader);
        }
        PullParser.sanityCheckEndElement(reader, event, parentTag);
    }

    private static Object getTypedValue(String type, String value) {
        if (type == null) {
            return value;
        }
        if ("Version".equals(type = type.trim())) {
            return Version.parseVersion((String)value);
        }
        if ("Long".equals(type)) {
            return Long.parseLong(value);
        }
        if ("Double".equals(type)) {
            return Double.parseDouble(value);
        }
        if ("List<String>".equals(type)) {
            return SpecXMLPullParser.parseStringList(value);
        }
        if ("List<Version>".equals(type)) {
            return SpecXMLPullParser.parseVersionList(value);
        }
        if ("List<Long>".equals(type)) {
            return SpecXMLPullParser.parseLongList(value);
        }
        if ("List<Double>".equals(type)) {
            return SpecXMLPullParser.parseDoubleList(value);
        }
        return value;
    }

    private static List<String> parseStringList(String value) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        block4: for (char c : value.toCharArray()) {
            if (escaped) {
                sb.append(c);
                escaped = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escaped = true;
                    continue block4;
                }
                case ',': {
                    l.add(sb.toString().trim());
                    sb.setLength(0);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            l.add(sb.toString().trim());
        }
        return l;
    }

    private static List<Version> parseVersionList(String value) {
        ArrayList<Version> l = new ArrayList<Version>();
        for (String v : value.split(",")) {
            l.add(Version.parseVersion((String)v.trim()));
        }
        return l;
    }

    private static List<Long> parseLongList(String value) {
        ArrayList<Long> l = new ArrayList<Long>();
        for (String x : value.split(",")) {
            l.add(Long.parseLong(x.trim()));
        }
        return l;
    }

    private static List<Double> parseDoubleList(String value) {
        ArrayList<Double> l = new ArrayList<Double>();
        for (String d : value.split(",")) {
            l.add(Double.parseDouble(d.trim()));
        }
        return l;
    }

    private static Requirement parseRequirement(XmlPullParser reader) throws Exception {
        RequirementImpl requirement = new RequirementImpl();
        String namespace = reader.getAttributeValue(null, NAMESPACE);
        if (!namespace.equals(NamespaceTranslator.getOSGiNamespace(namespace))) {
            throw new Exception("Namespace conflict. Namespace not allowed: " + namespace);
        }
        requirement.setName(NamespaceTranslator.getFelixNamespace(namespace));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        HashMap<String, String> directives = new HashMap<String, String>();
        SpecXMLPullParser.parseAttributesDirectives(reader, attributes, directives, REQUIREMENT);
        requirement.setAttributes(attributes);
        String filter = (String)directives.remove("filter");
        for (String ns : NamespaceTranslator.getTranslatedOSGiNamespaces()) {
            filter = filter.replaceAll("[(][ ]*" + ns + "[ ]*=", "(" + NamespaceTranslator.getFelixNamespace(ns) + "=");
        }
        requirement.setFilter(filter);
        requirement.setMultiple("multiple".equals(directives.remove("cardinality")));
        requirement.setOptional("optional".equals(directives.remove("resolution")));
        requirement.setDirectives(directives);
        requirement.setExtend(false);
        return requirement;
    }
}

